/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.datagen;

import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.block.custom.HangingBlock;
import net.luckystudio.spelunkers_charm.block.custom.PoweredLiftTrackBlock;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderBlock;
import net.luckystudio.spelunkers_charm.block.custom.boulder.HangingType;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.block.util.enums.BlockPart;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "spelunkers_charm", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE.get());
        this.modSimpleStairBlock((Block)ModBlocks.DUNESTONE_STAIRS.get(), SpelunkersCharm.id("block/dunestone"));
        this.modSimpleSlabBlock((Block)ModBlocks.DUNESTONE_SLAB.get(), SpelunkersCharm.id("block/dunestone"), SpelunkersCharm.id("block/dunestone"));
        this.modWallBlock((Block)ModBlocks.DUNESTONE_WALL.get(), SpelunkersCharm.id("block/dunestone"));
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_BRICKS.get());
        this.modSimpleStairBlock((Block)ModBlocks.DUNESTONE_BRICK_STAIRS.get(), SpelunkersCharm.id("block/dunestone_bricks"));
        this.modSimpleSlabBlock((Block)ModBlocks.DUNESTONE_BRICK_SLAB.get(), SpelunkersCharm.id("block/dunestone_bricks"), SpelunkersCharm.id("block/dunestone_bricks"));
        this.modWallBlock((Block)ModBlocks.DUNESTONE_BRICK_WALL.get(), SpelunkersCharm.id("block/dunestone_bricks"));
        this.modSimpleBlock((Block)ModBlocks.CHISELED_DUNESTONE_BRICKS.get());
        this.modSimpleBlock((Block)ModBlocks.COBBLED_DUNESTONE.get());
        this.modSimpleStairBlock((Block)ModBlocks.COBBLED_DUNESTONE_STAIRS.get(), SpelunkersCharm.id("block/cobbled_dunestone"));
        this.modSimpleSlabBlock((Block)ModBlocks.COBBLED_DUNESTONE_SLAB.get(), SpelunkersCharm.id("block/cobbled_dunestone"), SpelunkersCharm.id("block/cobbled_dunestone"));
        this.modWallBlock((Block)ModBlocks.COBBLED_DUNESTONE_WALL.get(), SpelunkersCharm.id("block/cobbled_dunestone"));
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST.get());
        this.modSimpleStairBlock((Block)ModBlocks.PERMAFROST_STAIRS.get(), SpelunkersCharm.id("block/permafrost"));
        this.modSimpleSlabBlock((Block)ModBlocks.PERMAFROST_SLAB.get(), SpelunkersCharm.id("block/permafrost"), SpelunkersCharm.id("block/permafrost"));
        this.modWallBlock((Block)ModBlocks.PERMAFROST_WALL.get(), SpelunkersCharm.id("block/permafrost"));
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_BRICKS.get());
        this.modSimpleStairBlock((Block)ModBlocks.PERMAFROST_BRICK_STAIRS.get(), SpelunkersCharm.id("block/permafrost_bricks"));
        this.modSimpleSlabBlock((Block)ModBlocks.PERMAFROST_BRICK_SLAB.get(), SpelunkersCharm.id("block/permafrost_bricks"), SpelunkersCharm.id("block/permafrost_bricks"));
        this.modWallBlock((Block)ModBlocks.PERMAFROST_BRICK_WALL.get(), SpelunkersCharm.id("block/permafrost_bricks"));
        this.modSimpleBlock((Block)ModBlocks.CHISELED_PERMAFROST_BRICKS.get());
        this.modSimpleBlock((Block)ModBlocks.COBBLED_PERMAFROST.get());
        this.modSimpleStairBlock((Block)ModBlocks.COBBLED_PERMAFROST_STAIRS.get(), SpelunkersCharm.id("block/cobbled_permafrost"));
        this.modSimpleSlabBlock((Block)ModBlocks.COBBLED_PERMAFROST_SLAB.get(), SpelunkersCharm.id("block/cobbled_permafrost"), SpelunkersCharm.id("block/cobbled_permafrost"));
        this.modWallBlock((Block)ModBlocks.COBBLED_PERMAFROST_WALL.get(), SpelunkersCharm.id("block/cobbled_permafrost"));
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE.get());
        this.modSimpleStairBlock((Block)ModBlocks.WILDSTONE_STAIRS.get(), SpelunkersCharm.id("block/wildstone"));
        this.modSimpleSlabBlock((Block)ModBlocks.WILDSTONE_SLAB.get(), SpelunkersCharm.id("block/wildstone"), SpelunkersCharm.id("block/wildstone"));
        this.modWallBlock((Block)ModBlocks.WILDSTONE_WALL.get(), SpelunkersCharm.id("block/wildstone"));
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_BRICKS.get());
        this.modSimpleStairBlock((Block)ModBlocks.WILDSTONE_BRICK_STAIRS.get(), SpelunkersCharm.id("block/wildstone_bricks"));
        this.modSimpleSlabBlock((Block)ModBlocks.WILDSTONE_BRICK_SLAB.get(), SpelunkersCharm.id("block/wildstone_bricks"), SpelunkersCharm.id("block/wildstone_bricks"));
        this.modWallBlock((Block)ModBlocks.WILDSTONE_BRICK_WALL.get(), SpelunkersCharm.id("block/wildstone_bricks"));
        this.modSimpleBlock((Block)ModBlocks.CHISELED_WILDSTONE_BRICKS.get());
        this.modSimpleBlock((Block)ModBlocks.COBBLED_WILDSTONE.get());
        this.modSimpleStairBlock((Block)ModBlocks.COBBLED_WILDSTONE_STAIRS.get(), SpelunkersCharm.id("block/cobbled_wildstone"));
        this.modSimpleSlabBlock((Block)ModBlocks.COBBLED_WILDSTONE_SLAB.get(), SpelunkersCharm.id("block/cobbled_wildstone"), SpelunkersCharm.id("block/cobbled_wildstone"));
        this.modWallBlock((Block)ModBlocks.COBBLED_WILDSTONE_WALL.get(), SpelunkersCharm.id("block/cobbled_wildstone"));
        this.modSimpleBlock((Block)ModBlocks.AMETHYST_BRICKS.get());
        this.modSimpleStairBlock((Block)ModBlocks.AMETHYST_BRICK_STAIRS.get(), SpelunkersCharm.id("block/amethyst_bricks"));
        this.modSimpleSlabBlock((Block)ModBlocks.AMETHYST_BRICK_SLAB.get(), SpelunkersCharm.id("block/amethyst_bricks"), SpelunkersCharm.id("block/amethyst_bricks"));
        this.modWallBlock((Block)ModBlocks.AMETHYST_BRICK_WALL.get(), SpelunkersCharm.id("block/amethyst_bricks"));
        this.modSimpleBlock((Block)ModBlocks.CHISELED_AMETHYST_BLOCK.get());
        this.modSimpleBlock((Block)ModBlocks.SILT.get());
        this.icicle((Block)ModBlocks.ICICLE.get(), this.mcLoc("block/packed_ice"));
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_COAL_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_IRON_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_COPPER_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_GOLD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_REDSTONE_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_EMERALD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_LAPIS_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_COAL_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_IRON_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_COPPER_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_GOLD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_REDSTONE_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_EMERALD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_COAL_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_IRON_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_COPPER_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_GOLD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_REDSTONE_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_EMERALD_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_LAPIS_ORE.get());
        this.modSimpleBlock((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get());
        this.boulderBlock((Block)ModBlocks.BOULDER.get());
        this.boulderBlock((Block)ModBlocks.IRON_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.COPPER_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.GOLD_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.LUSH_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.LUSH_IRON_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.LUSH_COPPER_BOULDER.get());
        this.boulderBlock((Block)ModBlocks.LUSH_GOLD_BOULDER.get());
        this.createHugeMushroomBlock((Block)ModBlocks.CAVE_MUSHROOM_BLOCK.get());
        this.simpleBlockWithGeneratedItem((Block)ModBlocks.CAVE_MUSHROOM.get());
        this.rockBlock((Block)ModBlocks.CLAY_PILE.get(), ResourceLocation.withDefaultNamespace((String)"block/clay"));
        this.rockBlock((Block)ModBlocks.ROCK.get(), ResourceLocation.withDefaultNamespace((String)"block/stone"));
        this.rockBlock((Block)ModBlocks.ICE_BALL.get(), ResourceLocation.withDefaultNamespace((String)"block/packed_ice"));
        this.rockBlock((Block)ModBlocks.DEEPSLATE_ROCK.get(), ResourceLocation.withDefaultNamespace((String)"block/deepslate"));
        this.rockBlock((Block)ModBlocks.DRIPSTONE_ROCK.get(), ResourceLocation.withDefaultNamespace((String)"block/dripstone_block"));
        this.rockBlock((Block)ModBlocks.BASALT_ROCK.get(), ResourceLocation.withDefaultNamespace((String)"block/basalt_side"));
        this.modSimpleBlock((Block)ModBlocks.PACKED_WEB.get());
        this.vineLikeBlock((Block)ModBlocks.WEB_VEIN.get());
        this.hangingBlock((Block)ModBlocks.HANGING_WEB.get());
        this.spiderEgg((Block)ModBlocks.SPIDER_EGG.get());
        this.simpleBlockWithItem((Block)ModBlocks.DEEPSLATE_GEYSER.get(), (ModelFile)this.models().cubeColumn("deepslate_geyser", ResourceLocation.withDefaultNamespace((String)"block/deepslate"), ResourceLocation.fromNamespaceAndPath((String)"spelunkers_charm", (String)"block/deepslate_geyser_top")));
        this.simpleBlockWithItem((Block)ModBlocks.BASALT_GEYSER.get(), (ModelFile)this.models().cubeColumn("basalt_geyser", ResourceLocation.withDefaultNamespace((String)"block/basalt_side"), ResourceLocation.fromNamespaceAndPath((String)"spelunkers_charm", (String)"block/basalt_geyser_top")));
        this.blaster((Block)ModBlocks.BLASTER.get());
        this.woodenLiftTrack((Block)ModBlocks.WOODEN_LIFT_TRACK.get());
        this.poweredLiftTrack((Block)ModBlocks.POWERED_LIFT_TRACK.get());
    }

    private void modSimpleBlock(Block block) {
        this.simpleBlock(block);
        this.itemModels().simpleBlockItem(block);
    }

    private void modSimpleStairBlock(Block block, ResourceLocation texture) {
        this.stairsBlock((StairBlock)block, texture);
        this.itemModels().simpleBlockItem(block);
    }

    private void modSimpleSlabBlock(Block block, ResourceLocation side, ResourceLocation top) {
        this.slabBlock((SlabBlock)block, side, top);
        this.itemModels().simpleBlockItem(block);
    }

    private void bottomTopBlock(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = this.models().cubeBottomTop(name, side, top, bottom);
        this.simpleBlock(block, (ModelFile)model);
    }

    private void modWallBlock(Block block, ResourceLocation texture) {
        ResourceLocation blockPath = BuiltInRegistries.BLOCK.getKey((Object)block);
        String name = blockPath.getPath();
        this.wallBlock((WallBlock)block, texture);
        this.itemModels().wallInventory(name, texture);
    }

    private void simpleBlockWithGeneratedItem(Block block) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(name, this.modLoc("block/" + name))).renderType("cutout"));
        ResourceLocation item = ResourceLocation.fromNamespaceAndPath((String)"spelunkers_charm", (String)name);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SpelunkersCharm.id("block/" + item.getPath()));
    }

    private void rockBlock(Block block, ResourceLocation breakParticle) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder rockOne = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_one", this.modLoc("block/template_rock_one"))).texture("all", this.modLoc("block/" + name))).texture("particle", breakParticle);
        ModelBuilder rockTwo = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_two", this.modLoc("block/template_rock_two"))).texture("all", this.modLoc("block/" + name))).texture("particle", breakParticle);
        ModelBuilder rockThree = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_three", this.modLoc("block/template_rock_three"))).texture("all", this.modLoc("block/" + name))).texture("particle", breakParticle);
        ModelBuilder displayPile = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_display", this.modLoc("block/template_rock_pile_display"))).texture("all", this.modLoc("block/" + name))).texture("particle", breakParticle);
        if (block != ModBlocks.CLAY_PILE.get()) {
            this.itemModels().basicItem(block.asItem());
        }
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$rockBlock$0((ModelFile)displayPile, (ModelFile)rockTwo, (ModelFile)rockThree, (ModelFile)rockOne, arg_0), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void createHugeMushroomBlock(Block block) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, this.mcLoc("block/cube_all"))).texture("all", this.modLoc("block/cave_mushroom_block"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().singleTexture("cave_mushroom_block", this.mcLoc("block/template_single_face"), this.modLoc("block/cave_mushroom_block"))).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).rotationY(90).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).rotationY(180).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).rotationY(270).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).rotationX(270).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/mushroom_block_inside"))).rotationX(90).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false}).end();
    }

    private void icicle(Block block, ResourceLocation breakParticle) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder down_base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_down_base", this.mcLoc("block/pointed_dripstone_down_base"))).texture("cross", this.modLoc("block/icicle_down_base"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder up_base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_up_base", this.mcLoc("block/pointed_dripstone_up_base"))).texture("cross", this.modLoc("block/icicle_up_base"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder down_frustum = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_down_frustum", this.mcLoc("block/pointed_dripstone_down_frustum"))).texture("cross", this.modLoc("block/icicle_down_frustum"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder up_frustum = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_up_frustum", this.mcLoc("block/pointed_dripstone_up_frustum"))).texture("cross", this.modLoc("block/icicle_up_frustum"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder down_middle = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_down_middle", this.mcLoc("block/pointed_dripstone_down_middle"))).texture("cross", this.modLoc("block/icicle_down_middle"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder up_middle = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_up_middle", this.mcLoc("block/pointed_dripstone_up_middle"))).texture("cross", this.modLoc("block/icicle_up_middle"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder down_tip = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_down_tip", this.mcLoc("block/pointed_dripstone_down_tip"))).texture("cross", this.modLoc("block/icicle_down_tip"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder up_tip = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_up_tip", this.mcLoc("block/pointed_dripstone_up_tip"))).texture("cross", this.modLoc("block/icicle_up_tip"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder down_tip_merge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_down_tip_merge", this.mcLoc("block/pointed_dripstone_down_tip_merge"))).texture("cross", this.modLoc("block/icicle_down_tip_merge"))).texture("particle", breakParticle)).renderType("cutout");
        ModelBuilder up_tip_merge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_up_tip_merge", this.mcLoc("block/pointed_dripstone_up_tip_merge"))).texture("cross", this.modLoc("block/icicle_up_tip_merge"))).texture("particle", breakParticle)).renderType("cutout");
        this.itemModels().basicItem(block.asItem());
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$icicle$1((ModelFile)down_base, (ModelFile)up_base, (ModelFile)down_frustum, (ModelFile)up_frustum, (ModelFile)down_middle, (ModelFile)up_middle, (ModelFile)down_tip, (ModelFile)up_tip, (ModelFile)down_tip_merge, (ModelFile)up_tip_merge, arg_0), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void vineLikeBlock(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String textureName = "block/" + blockName;
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SpelunkersCharm.id(textureName));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_north", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_east", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_south", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_west", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_up", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_down", this.mcLoc("block/sculk_vein"))).renderType("cutout")).texture("sculk_vein", this.modLoc(textureName))).texture("particle", this.modLoc(textureName))).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{true}).end();
    }

    private void spiderEgg(Block block) {
        ModelBuilder stageOne = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("spider_egg_stage_0", this.modLoc("block/spider_egg"))).texture("all", this.modLoc("block/spider_egg_stage_0"))).texture("particle", this.modLoc("block/spider_egg_break"))).renderType("cutout");
        ModelBuilder stageTwo = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("spider_egg_stage_1", this.modLoc("block/spider_egg"))).texture("all", this.modLoc("block/spider_egg_stage_1"))).texture("particle", this.modLoc("block/spider_egg_break"))).renderType("cutout");
        ModelBuilder stageThree = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("spider_egg_stage_2", this.modLoc("block/spider_egg"))).texture("all", this.modLoc("block/spider_egg_stage_2"))).texture("particle", this.modLoc("block/spider_egg_break"))).renderType("cutout");
        this.itemModels().basicItem(block.asItem());
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$spiderEgg$2((ModelFile)stageTwo, (ModelFile)stageThree, (ModelFile)stageOne, arg_0));
    }

    private void hangingBlock(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String textureName = "block/" + blockName;
        ResourceLocation endTexture = this.modLoc("block/" + blockName + "_end");
        ResourceLocation mainTexture = this.modLoc("block/" + blockName);
        ModelBuilder endModel = ((BlockModelBuilder)this.models().cross(blockName + "_end", endTexture)).renderType("cutout");
        ModelBuilder mainModel = ((BlockModelBuilder)this.models().cross(blockName, mainTexture)).renderType("cutout");
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SpelunkersCharm.id(textureName));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$hangingBlock$3((ModelFile)endModel, (ModelFile)mainModel, arg_0));
    }

    private void woodenLiftTrack(Block block) {
        ModelBuilder blockModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("wooden_lift_track", this.modLoc("block/template_lift_track"))).texture("front", this.modLoc("block/wooden_lift_track_front"))).texture("side", this.modLoc("block/wooden_lift_track_side"))).texture("end", this.modLoc("block/wooden_lift_track_end"))).texture("particle", this.modLoc("block/wooden_lift_track_front"))).renderType("cutout");
        this.horizontalBlock(block, (ModelFile)blockModel);
        this.itemModels().simpleBlockItem(block);
    }

    private void poweredLiftTrack(Block block) {
        ModelBuilder blockModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("powered_lift_track", this.modLoc("block/template_lift_track"))).texture("front", this.modLoc("block/powered_lift_track_front"))).texture("side", this.modLoc("block/powered_lift_track_side"))).texture("end", this.modLoc("block/powered_lift_track_end"))).texture("particle", this.modLoc("block/powered_lift_track_front"))).renderType("cutout");
        ModelBuilder poweredBlockModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("powered_lift_track_powered", this.modLoc("block/template_lift_track"))).texture("front", this.modLoc("block/powered_lift_track_front_powered"))).texture("side", this.modLoc("block/powered_lift_track_side"))).texture("end", this.modLoc("block/powered_lift_track_end_powered"))).texture("particle", this.modLoc("block/powered_lift_track_front_powered"))).renderType("cutout");
        this.itemModels().simpleBlockItem(block);
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$poweredLiftTrack$4((ModelFile)poweredBlockModel, (ModelFile)blockModel, arg_0));
    }

    private void boulderBlock(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String textureName = "block/boulder/" + blockName;
        ModelBuilder bottomCorner = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_corner", this.modLoc("block/template_boulder_bottom_corner"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomSide = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_side", this.modLoc("block/template_boulder_bottom_side"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomMiddle = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_middle", this.modLoc("block/template_boulder_bottom_middle"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleCorner = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_corner", this.modLoc("block/template_boulder_middle_corner"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleSide = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_side", this.modLoc("block/template_boulder_middle_side"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topCorner = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_corner", this.modLoc("block/template_boulder_top_corner"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topSide = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_side", this.modLoc("block/template_boulder_top_side"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topMiddle = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_middle", this.modLoc("block/template_boulder_top_middle"))).texture("all", textureName)).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomCorner_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_corner_tied", this.modLoc("block/template_boulder_bottom_corner"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomSide_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_side_tied", this.modLoc("block/template_boulder_bottom_side"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomMiddle_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_middle_tied", this.modLoc("block/template_boulder_bottom_middle"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleCorner_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_corner_tied", this.modLoc("block/template_boulder_middle_corner"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleSide_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_side_tied", this.modLoc("block/template_boulder_middle_side"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topCorner_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_corner_tied", this.modLoc("block/template_boulder_top_corner"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topSide_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_side_tied", this.modLoc("block/template_boulder_top_side"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topMiddle_tied = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_middle_tied", this.modLoc("block/template_boulder_top_middle"))).texture("all", textureName + "_tied")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomCorner_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_corner_chained", this.modLoc("block/template_boulder_bottom_corner"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomSide_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_side_chained", this.modLoc("block/template_boulder_bottom_side"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder bottomMiddle_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom_middle_chained", this.modLoc("block/template_boulder_bottom_middle"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleCorner_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_corner_chained", this.modLoc("block/template_boulder_middle_corner"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder middleSide_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_middle_side_chained", this.modLoc("block/template_boulder_middle_side"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topCorner_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_corner_chained", this.modLoc("block/template_boulder_top_corner"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topSide_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_side_chained", this.modLoc("block/template_boulder_top_side"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ModelBuilder topMiddle_chained = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_top_middle_chained", this.modLoc("block/template_boulder_top_middle"))).texture("all", textureName + "_chained")).texture("particle", this.modLoc("block/boulder_break"));
        ((ItemModelBuilder)this.itemModels().withExistingParent(blockName, this.modLoc("block/template_boulder_bottom_corner"))).texture("all", textureName);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$boulderBlock$5((ModelFile)bottomCorner_tied, (ModelFile)bottomCorner_chained, (ModelFile)bottomCorner, (ModelFile)bottomSide_tied, (ModelFile)bottomSide_chained, (ModelFile)bottomSide, (ModelFile)bottomMiddle_tied, (ModelFile)bottomMiddle_chained, (ModelFile)bottomMiddle, (ModelFile)middleCorner_tied, (ModelFile)middleCorner_chained, (ModelFile)middleCorner, (ModelFile)middleSide_tied, (ModelFile)middleSide_chained, (ModelFile)middleSide, (ModelFile)topCorner_tied, (ModelFile)topCorner_chained, (ModelFile)topCorner, (ModelFile)topSide_tied, (ModelFile)topSide_chained, (ModelFile)topSide, (ModelFile)topMiddle_tied, (ModelFile)topMiddle_chained, (ModelFile)topMiddle, arg_0), new Property[]{BlockStateProperties.WATERLOGGED, BoulderBlock.GENERATE});
    }

    private void modCrossBlock(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String textureName = "block/" + blockName;
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SpelunkersCharm.id(textureName));
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName, this.mcLoc("block/cross"))).texture("cross", textureName)).renderType("cutout"));
    }

    private void modDoubleTallPlant(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String textureName = "block/" + blockName;
        ModelBuilder bottomPart = ((BlockModelBuilder)this.models().withExistingParent(blockName + "_bottom", this.mcLoc("block/cross"))).texture("cross", textureName + "_bottom");
        ModelBuilder topPart = ((BlockModelBuilder)this.models().withExistingParent(blockName + "_top", this.modLoc("block/template_boulder_top_middle"))).texture("cross", textureName + "_top");
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SpelunkersCharm.id(textureName + "_top"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$modDoubleTallPlant$6((ModelFile)topPart, (ModelFile)bottomPart, arg_0));
    }

    private void blaster(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder offModel = this.models().cubeBottomTop(blockName + "_off", SpelunkersCharm.id("block/blaster_side_off"), this.mcLoc("block/crafter_bottom"), SpelunkersCharm.id("block/blaster_top_off"));
        ModelBuilder onModel = this.models().cubeBottomTop(blockName + "_on", SpelunkersCharm.id("block/blaster_side_on"), this.mcLoc("block/crafter_bottom"), SpelunkersCharm.id("block/blaster_top_on"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$blaster$7((ModelFile)onModel, (ModelFile)offModel, arg_0));
        this.itemModels().withExistingParent("blaster", this.modLoc("block/blaster_off"));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$blaster$7(ModelFile onModel, ModelFile offModel, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        Boolean triggered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
        return ConfiguredModel.builder().modelFile(triggered != false ? onModel : offModel).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$modDoubleTallPlant$6(ModelFile topPart, ModelFile bottomPart, BlockState state) {
        DoubleBlockHalf blockPart = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
        ModelFile modelFile = switch (blockPart) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> topPart;
            case DoubleBlockHalf.LOWER -> bottomPart;
        };
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$boulderBlock$5(ModelFile bottomCorner_tied, ModelFile bottomCorner_chained, ModelFile bottomCorner, ModelFile bottomSide_tied, ModelFile bottomSide_chained, ModelFile bottomSide, ModelFile bottomMiddle_tied, ModelFile bottomMiddle_chained, ModelFile bottomMiddle, ModelFile middleCorner_tied, ModelFile middleCorner_chained, ModelFile middleCorner, ModelFile middleSide_tied, ModelFile middleSide_chained, ModelFile middleSide, ModelFile topCorner_tied, ModelFile topCorner_chained, ModelFile topCorner, ModelFile topSide_tied, ModelFile topSide_chained, ModelFile topSide, ModelFile topMiddle_tied, ModelFile topMiddle_chained, ModelFile topMiddle, BlockState state) {
        BlockPart blockPart = (BlockPart)((Object)state.getValue(BoulderBlock.BLOCK_PART));
        HangingType hangingType = (HangingType)((Object)state.getValue(BoulderBlock.HANGING_TYPE));
        ModelFile modelFile = switch (blockPart) {
            default -> throw new MatchException(null, null);
            case BlockPart.BOTTOM_CORNER -> {
                switch (hangingType) {
                    case TIED: {
                        yield bottomCorner_tied;
                    }
                    case CHAINED: {
                        yield bottomCorner_chained;
                    }
                }
                yield bottomCorner;
            }
            case BlockPart.BOTTOM_SIDE -> {
                switch (hangingType) {
                    case TIED: {
                        yield bottomSide_tied;
                    }
                    case CHAINED: {
                        yield bottomSide_chained;
                    }
                }
                yield bottomSide;
            }
            case BlockPart.BOTTOM_MIDDLE -> {
                switch (hangingType) {
                    case TIED: {
                        yield bottomMiddle_tied;
                    }
                    case CHAINED: {
                        yield bottomMiddle_chained;
                    }
                }
                yield bottomMiddle;
            }
            case BlockPart.MIDDLE_CORNER -> {
                switch (hangingType) {
                    case TIED: {
                        yield middleCorner_tied;
                    }
                    case CHAINED: {
                        yield middleCorner_chained;
                    }
                }
                yield middleCorner;
            }
            case BlockPart.MIDDLE_SIDE -> {
                switch (hangingType) {
                    case TIED: {
                        yield middleSide_tied;
                    }
                    case CHAINED: {
                        yield middleSide_chained;
                    }
                }
                yield middleSide;
            }
            case BlockPart.TOP_CORNER -> {
                switch (hangingType) {
                    case TIED: {
                        yield topCorner_tied;
                    }
                    case CHAINED: {
                        yield topCorner_chained;
                    }
                }
                yield topCorner;
            }
            case BlockPart.TOP_SIDE -> {
                switch (hangingType) {
                    case TIED: {
                        yield topSide_tied;
                    }
                    case CHAINED: {
                        yield topSide_chained;
                    }
                }
                yield topSide;
            }
            case BlockPart.TOP_MIDDLE -> {
                switch (hangingType) {
                    case TIED: {
                        yield topMiddle_tied;
                    }
                    case CHAINED: {
                        yield topMiddle_chained;
                    }
                }
                yield topMiddle;
            }
        };
        return ConfiguredModel.builder().modelFile(modelFile).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.FACING)).toYRot() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$poweredLiftTrack$4(ModelFile poweredBlockModel, ModelFile blockModel, BlockState state) {
        boolean powered = (Boolean)state.getValue((Property)PoweredLiftTrackBlock.POWERED);
        ModelFile selectedModel = powered ? poweredBlockModel : blockModel;
        return ConfiguredModel.builder().modelFile(selectedModel).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$hangingBlock$3(ModelFile endModel, ModelFile mainModel, BlockState state) {
        boolean end = (Boolean)state.getValue((Property)HangingBlock.END);
        ModelFile selectedModel = end ? endModel : mainModel;
        return ConfiguredModel.builder().modelFile(selectedModel).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$spiderEgg$2(ModelFile stageTwo, ModelFile stageThree, ModelFile stageOne, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        int stage = (Integer)state.getValue((Property)BlockStateProperties.HATCH);
        ModelFile model = switch (stage) {
            case 1 -> stageTwo;
            case 2 -> stageThree;
            default -> stageOne;
        };
        return ConfiguredModel.builder().modelFile(model).rotationX(direction == Direction.DOWN ? 180 : (direction.getAxis().isHorizontal() ? 90 : 0)).rotationY(direction.getAxis().isVertical() ? 0 : ((int)direction.toYRot() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$icicle$1(ModelFile down_base, ModelFile up_base, ModelFile down_frustum, ModelFile up_frustum, ModelFile down_middle, ModelFile up_middle, ModelFile down_tip, ModelFile up_tip, ModelFile down_tip_merge, ModelFile up_tip_merge, BlockState state) {
        DripstoneThickness thickness = (DripstoneThickness)state.getValue((Property)BlockStateProperties.DRIPSTONE_THICKNESS);
        Direction vertical_direction = (Direction)state.getValue((Property)BlockStateProperties.VERTICAL_DIRECTION);
        ModelFile model = switch (thickness) {
            default -> throw new MatchException(null, null);
            case DripstoneThickness.BASE -> {
                if (vertical_direction == Direction.DOWN) {
                    yield down_base;
                }
                yield up_base;
            }
            case DripstoneThickness.FRUSTUM -> {
                if (vertical_direction == Direction.DOWN) {
                    yield down_frustum;
                }
                yield up_frustum;
            }
            case DripstoneThickness.MIDDLE -> {
                if (vertical_direction == Direction.DOWN) {
                    yield down_middle;
                }
                yield up_middle;
            }
            case DripstoneThickness.TIP -> {
                if (vertical_direction == Direction.DOWN) {
                    yield down_tip;
                }
                yield up_tip;
            }
            case DripstoneThickness.TIP_MERGE -> vertical_direction == Direction.DOWN ? down_tip_merge : up_tip_merge;
        };
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$rockBlock$0(ModelFile displayPile, ModelFile rockTwo, ModelFile rockThree, ModelFile rockOne, BlockState state) {
        ModelFile modelFile;
        Direction facing = (Direction)state.getValue((Property)ButtonBlock.FACING);
        int rocks = (Integer)state.getValue((Property)ModBlockStateProperties.ROCKS);
        boolean display = (Boolean)state.getValue((Property)ModBlockStateProperties.DISPLAY);
        if (display) {
            modelFile = displayPile;
        } else {
            switch (rocks) {
                case 2: {
                    modelFile = rockTwo;
                    break;
                }
                case 3: {
                    modelFile = rockThree;
                    break;
                }
                default: {
                    modelFile = rockOne;
                }
            }
        }
        ModelFile selectedModel = modelFile;
        return ConfiguredModel.builder().modelFile(selectedModel).rotationY((int)facing.getOpposite().toYRot()).build();
    }
}

