/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.datagen;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.CompletableFuture;
import net.luckystudio.spelunkers_charm.datagen.itemTags.ModItemTags;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.init.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public static final ImmutableList<ItemLike> COAL_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_COAL_ORE, ModBlocks.WILDSTONE_COAL_ORE, ModBlocks.PERMAFROST_COAL_ORE);
    public static final ImmutableList<ItemLike> IRON_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_IRON_ORE, ModBlocks.WILDSTONE_IRON_ORE, ModBlocks.PERMAFROST_IRON_ORE);
    public static final ImmutableList<ItemLike> COPPER_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_COPPER_ORE, ModBlocks.WILDSTONE_COPPER_ORE, ModBlocks.PERMAFROST_COPPER_ORE);
    public static final ImmutableList<ItemLike> GOLD_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_GOLD_ORE, ModBlocks.WILDSTONE_GOLD_ORE, ModBlocks.PERMAFROST_GOLD_ORE);
    public static final ImmutableList<ItemLike> REDSTONE_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_REDSTONE_ORE, ModBlocks.WILDSTONE_REDSTONE_ORE, ModBlocks.PERMAFROST_REDSTONE_ORE);
    public static final ImmutableList<ItemLike> EMERALD_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_EMERALD_ORE, ModBlocks.WILDSTONE_EMERALD_ORE, ModBlocks.PERMAFROST_EMERALD_ORE);
    public static final ImmutableList<ItemLike> LAPIS_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_LAPIS_ORE, ModBlocks.WILDSTONE_LAPIS_ORE, ModBlocks.PERMAFROST_LAPIS_ORE);
    public static final ImmutableList<ItemLike> DIAMOND_SMELTABLES = ImmutableList.of(ModBlocks.DUNESTONE_DIAMOND_ORE, ModBlocks.WILDSTONE_DIAMOND_ORE, ModBlocks.PERMAFROST_DIAMOND_ORE);

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    private void rockRecipe(Item input, Item output, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_rock", ModRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    private void stoneBrickRecipe(Item input, Item output, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_stone", ModRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    private void blaster(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.BLASTER.asItem(), (int)1).pattern("%#%").pattern("#@#").pattern("###").define(Character.valueOf('%'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('@'), ModItemTags.GEYSERS).unlockedBy("has_geyser", ModRecipeProvider.has(ModItemTags.GEYSERS)).save(recipeOutput);
    }

    private void candleHelmet(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ModItems.CANDLE_HELMET, (int)1).pattern(" % ").pattern("@#@").pattern("# #").define(Character.valueOf('%'), (ItemLike)Items.CANDLE).define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('@'), ItemTags.PLANKS).unlockedBy("has_iron", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.DUNESTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.DUNESTONE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.DUNESTONE_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE.asItem()}));
        this.stoneBrickRecipe(ModBlocks.DUNESTONE.asItem(), ModBlocks.DUNESTONE_BRICKS.asItem(), recipeOutput);
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.DUNESTONE_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE_BRICKS.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.DUNESTONE_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE_BRICKS.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.DUNESTONE_BRICK_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE_BRICKS.asItem()}));
        ModRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_DUNESTONE_BRICKS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.DUNESTONE_BRICKS.asItem()}));
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.COBBLED_DUNESTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_DUNESTONE.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_DUNESTONE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_DUNESTONE.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_DUNESTONE_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_DUNESTONE.asItem()}));
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.WILDSTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WILDSTONE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WILDSTONE_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE.asItem()}));
        this.stoneBrickRecipe(ModBlocks.WILDSTONE.asItem(), ModBlocks.WILDSTONE_BRICKS.asItem(), recipeOutput);
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.WILDSTONE_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE_BRICKS.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WILDSTONE_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE_BRICKS.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WILDSTONE_BRICK_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE_BRICKS.asItem()}));
        ModRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_WILDSTONE_BRICKS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.WILDSTONE_BRICKS.asItem()}));
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.COBBLED_WILDSTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_WILDSTONE.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_WILDSTONE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_WILDSTONE.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_WILDSTONE_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_WILDSTONE.asItem()}));
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.PERMAFROST_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.PERMAFROST_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.PERMAFROST_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST.asItem()}));
        this.stoneBrickRecipe(ModBlocks.PERMAFROST.asItem(), ModBlocks.PERMAFROST_BRICKS.asItem(), recipeOutput);
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.PERMAFROST_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST_BRICKS.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.PERMAFROST_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST_BRICKS.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.PERMAFROST_BRICK_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST_BRICKS.asItem()}));
        ModRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_PERMAFROST_BRICKS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.PERMAFROST_BRICKS.asItem()}));
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.COBBLED_PERMAFROST_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_PERMAFROST.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_PERMAFROST_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_PERMAFROST.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COBBLED_PERMAFROST_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.COBBLED_PERMAFROST.asItem()}));
        this.stoneBrickRecipe(Blocks.AMETHYST_BLOCK.asItem(), ModBlocks.AMETHYST_BRICKS.asItem(), recipeOutput);
        ModRecipeProvider.stairBuilder((ItemLike)((ItemLike)ModBlocks.AMETHYST_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.AMETHYST_BRICKS.asItem()}));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.AMETHYST_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.AMETHYST_BRICKS.asItem()}));
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.AMETHYST_BRICK_WALL.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.AMETHYST_BRICKS.asItem()}));
        ModRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_AMETHYST_BLOCK.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModBlocks.AMETHYST_BRICKS.asItem()}));
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, COAL_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COAL, (float)0.1f, (int)200, (String)"coal");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, IRON_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, (float)0.7f, (int)200, (String)"iron_ingot");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, COPPER_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, (float)0.7f, (int)200, (String)"copper_ingot");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, GOLD_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, (float)1.0f, (int)200, (String)"gold_ingot");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, DIAMOND_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND, (float)1.0f, (int)200, (String)"diamond");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, LAPIS_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, (float)0.2f, (int)200, (String)"lapis_lazuli");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, REDSTONE_SMELTABLES, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, (float)0.7f, (int)200, (String)"redstone");
        ModRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, EMERALD_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.EMERALD, (float)1.0f, (int)200, (String)"emerald");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, COAL_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COAL, (float)0.1f, (int)100, (String)"coal");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, IRON_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, (float)0.7f, (int)100, (String)"iron_ingot");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, COPPER_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, (float)0.7f, (int)100, (String)"copper_ingot");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, GOLD_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, (float)1.0f, (int)100, (String)"gold_ingot");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, DIAMOND_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND, (float)1.0f, (int)100, (String)"diamond");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, LAPIS_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, (float)0.2f, (int)100, (String)"lapis_lazuli");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, REDSTONE_SMELTABLES, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, (float)0.7f, (int)100, (String)"redstone");
        ModRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, EMERALD_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.EMERALD, (float)1.0f, (int)100, (String)"emerald");
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ModBlocks.PACKED_WEB);
        this.rockRecipe(ModBlocks.ROCK.asItem(), Blocks.COBBLESTONE.asItem(), recipeOutput);
        this.rockRecipe(ModBlocks.DEEPSLATE_ROCK.asItem(), Blocks.COBBLED_DEEPSLATE.asItem(), recipeOutput);
        this.rockRecipe(ModBlocks.DRIPSTONE_ROCK.asItem(), Blocks.DRIPSTONE_BLOCK.asItem(), recipeOutput);
        this.rockRecipe(ModBlocks.BASALT_ROCK.asItem(), Blocks.BASALT.asItem(), recipeOutput);
        this.candleHelmet(recipeOutput);
        this.blaster(recipeOutput);
    }
}

