/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.custom.lift;

import java.util.List;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.datagen.itemTags.ModItemTags;
import net.luckystudio.spelunkers_charm.entity.custom.lift.large.LargeLift;
import net.luckystudio.spelunkers_charm.entity.custom.lift.medium.MediumLift;
import net.luckystudio.spelunkers_charm.entity.custom.lift.small.SmallLift;
import net.luckystudio.spelunkers_charm.entity.util.ControlType;
import net.luckystudio.spelunkers_charm.entity.util.MineralType;
import net.luckystudio.spelunkers_charm.entity.util.MovementType;
import net.luckystudio.spelunkers_charm.entity.util.WoodType;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.init.ModItems;
import net.luckystudio.spelunkers_charm.init.ModParticleTypes;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.minecraft.BlockUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLift
extends VehicleEntity {
    private static final EntityDataAccessor<Integer> CONTROL_TYPE = SynchedEntityData.defineId(AbstractLift.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MOVEMENT_DIRECTION = SynchedEntityData.defineId(AbstractLift.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> WOOD_TYPE = SynchedEntityData.defineId(AbstractLift.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MINERAL_TYPE = SynchedEntityData.defineId(AbstractLift.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public AnimationState upAnimationState = new AnimationState();
    public AnimationState downAnimationState = new AnimationState();
    private boolean wasOnGround = false;
    private boolean wasOnCeiling = false;
    private float currentLeverAngle = 0.0f;
    private final float movementSpeed = 0.15f;
    private final Type type;

    public AbstractLift(EntityType<?> entityType, Level level, Type type) {
        super(entityType, level);
        this.type = type;
    }

    protected AbstractLift(EntityType<?> entityType, Level level, Type type, double x, double y, double z) {
        this(entityType, level, type);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public static AbstractLift createLift(ServerLevel level, double x, double y, double z, Type type, ItemStack stack, @Nullable Player player) {
        AbstractLift abstractLift = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new SmallLift((Level)level, x, y, z);
            case 1 -> new MediumLift((Level)level, x, y, z);
            case 2 -> new LargeLift((Level)level, x, y, z);
        };
        EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, (Player)player).accept(abstractLift);
        return abstractLift;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CONTROL_TYPE, (Object)ControlType.AUTOMATIC.ordinal());
        builder.define(MOVEMENT_DIRECTION, (Object)MovementType.STATIONARY.ordinal());
        builder.define(WOOD_TYPE, (Object)WoodType.SPRUCE.ordinal());
        builder.define(MINERAL_TYPE, (Object)MineralType.IRON.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("controlType", ((Integer)this.entityData.get(CONTROL_TYPE)).intValue());
        compound.putString("movementDirection", this.getMovementType().getSerializedName());
        compound.putString("woodType", this.getWoodType().getSerializedName());
        compound.putString("mineralType", this.getMineralType().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("controlType", 8)) {
            this.setControlType(ControlType.byName(compound.getString("controlType")));
        }
        if (compound.contains("movementDirection", 8)) {
            this.setMovementType(MovementType.byName(compound.getString("movementDirection")));
        }
        if (compound.contains("woodType", 8)) {
            this.setWoodType(WoodType.byName(compound.getString("woodType")));
        }
        if (compound.contains("mineralType", 8)) {
            this.setMineralType(MineralType.byName(compound.getString("mineralType")));
        }
    }

    public ControlType getControlType() {
        return ControlType.byId((Integer)this.entityData.get(MOVEMENT_DIRECTION));
    }

    public void setControlType(ControlType direction) {
        this.entityData.set(CONTROL_TYPE, (Object)direction.ordinal());
    }

    public MovementType getMovementType() {
        return MovementType.byId((Integer)this.entityData.get(MOVEMENT_DIRECTION));
    }

    public void setMovementType(MovementType direction) {
        this.entityData.set(MOVEMENT_DIRECTION, (Object)direction.ordinal());
    }

    public WoodType getWoodType() {
        return WoodType.byId((Integer)this.entityData.get(WOOD_TYPE));
    }

    public void setWoodType(WoodType variant) {
        this.entityData.set(WOOD_TYPE, (Object)variant.ordinal());
    }

    public MineralType getMineralType() {
        return MineralType.byId((Integer)this.entityData.get(MINERAL_TYPE));
    }

    public void setMineralType(MineralType variant) {
        this.entityData.set(MINERAL_TYPE, (Object)variant.ordinal());
    }

    public void tick() {
        super.tick();
        Direction direction = this.getDirection();
        Vec3 frontPos = new Vec3(this.getX(), this.getY(), this.getZ()).add(0.0, 0.5, 0.0).relative(direction, 3.0);
        this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, frontPos.x, frontPos.y, frontPos.z, 0.0, 0.0, 0.0);
        this.snapHorizontallyToGrid();
        if (this.hasTracks(0)) {
            MovementType movement = this.getMovementType();
            if (movement == MovementType.FALLING) {
                this.setMovementType(MovementType.STATIONARY);
                movement = MovementType.STATIONARY;
            }
            if (movement == MovementType.STATIONARY) {
                this.snapVerticallyToGrid();
            }
            if (movement == MovementType.UP) {
                if (this.hasTracks(1) && !this.onCeiling()) {
                    this.setDeltaMovement(this.getDeltaMovement().x, 0.15f, this.getDeltaMovement().z);
                } else {
                    this.playStopSound();
                    this.setMovementType(MovementType.STATIONARY);
                }
            }
            if (movement == MovementType.DOWN) {
                if (this.hasTracks(-1) && !this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().x, -0.15f, this.getDeltaMovement().z);
                } else {
                    this.playStopSound();
                    this.setMovementType(MovementType.STATIONARY);
                }
            }
        } else {
            if (this.onGround()) {
                this.setMovementType(MovementType.FALLING);
            } else {
                this.setMovementType(MovementType.STATIONARY);
            }
            this.applyGravity();
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        boolean currentlyOnCeiling = this.onCeiling();
        if (!this.wasOnCeiling && currentlyOnCeiling) {
            this.onArise();
        }
        this.wasOnCeiling = currentlyOnCeiling;
        boolean currentlyOnGround = this.onGround();
        if (!this.wasOnGround && currentlyOnGround) {
            this.onLanding();
        }
        this.wasOnGround = currentlyOnGround;
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        this.upAnimationState.start(this.tickCount);
    }

    private void setupAnimationStates() {
        if (this.getMovementType() == MovementType.UP) {
            this.upAnimationState.start(this.tickCount);
        } else {
            this.upAnimationState.stop();
        }
        if (this.getMovementType() == MovementType.DOWN) {
            this.downAnimationState.startIfStopped(this.tickCount);
        } else {
            this.downAnimationState.stop();
        }
    }

    private void playStartSound() {
        this.level().playSound((Entity)this, this.blockPosition(), ModSoundEvents.LIFT_START.get(), SoundSource.BLOCKS, this.getLevelBasedOnType(), this.getPitchBasedOnType());
    }

    private void playStopSound() {
        this.level().playSound((Entity)this, this.blockPosition(), ModSoundEvents.LIFT_STOP.get(), SoundSource.BLOCKS, this.getLevelBasedOnType(), this.getPitchBasedOnType());
    }

    public boolean onCeiling() {
        AABB aabb = this.getBoundingBox();
        AABB ceilingCheckBox = new AABB(aabb.minX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY + 1.0E-6, aabb.maxZ);
        return this.level().findSupportingBlock((Entity)this, ceilingCheckBox).isPresent();
    }

    private void snapVerticallyToGrid() {
        double y = this.getBlockY();
        this.setPos(this.getX(), y, this.getZ());
        this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
    }

    private void snapHorizontallyToGrid() {
        double x = this.getX();
        double z = this.getZ();
        double targetX = Math.floor(x) + 0.5;
        double targetZ = Math.floor(z) + 0.5;
        double dx = targetX - x;
        double dz = targetZ - z;
        if (Math.abs(dx) > 0.01 || Math.abs(dz) > 0.01) {
            this.setPos(targetX, this.getY(), targetZ);
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        }
    }

    protected void onArise() {
        ModParticleTypes.spawnSquareBorderParticles(this.level(), (ParticleOptions)ParticleTypes.DUST_PLUME, this.blockPosition().above(), this.getBbWidth() / 2.0f, (int)(10.0f * this.getBbWidth()), 0.1f);
    }

    protected void onLanding() {
        ModParticleTypes.spawnSquareBorderParticles(this.level(), (ParticleOptions)ParticleTypes.DUST_PLUME, this.blockPosition(), this.getBbWidth() / 2.0f, (int)(10.0f * this.getBbWidth()), 0.1f);
    }

    @NotNull
    protected Item getDropItem() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Item)ModItems.SMALL_LIFT.get();
            case 1 -> (Item)ModItems.MEDIUM_LIFT.get();
            case 2 -> (Item)ModItems.LARGE_LIFT.get();
        };
    }

    protected float getLevelBasedOnType() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 1.0f;
            case 1 -> 1.25f;
            case 2 -> 1.5f;
        };
    }

    protected float getPitchBasedOnType() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 1.0f;
            case 1 -> 0.75f;
            case 2 -> 0.25f;
        };
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!source.isDirect()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(ItemTags.PLANKS)) {
            WoodType woodType = WoodType.getWoodType(itemStack);
            if (woodType == null) {
                return super.interact(player, hand);
            }
            this.setWoodType(woodType);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (itemStack.is(ModItemTags.MINERALS)) {
            MineralType mineralType = MineralType.getMineralType(itemStack);
            if (mineralType == null) {
                return super.interact(player, hand);
            }
            this.setMineralType(mineralType);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (block instanceof LeverBlock) {
                this.setControlType(ControlType.LEVER);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (block instanceof PressurePlateBlock) {
                this.setControlType(ControlType.PRESSURE_PLATE);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.getControlType() == ControlType.AUTOMATIC) {
            return this.toggleMovementDirection();
        }
        return super.interact(player, hand);
    }

    private InteractionResult toggleMovementDirection() {
        if (this.getMovementType() == MovementType.STATIONARY && this.hasTracks(0)) {
            if (this.hasTracks(1) && !this.onCeiling()) {
                this.playStartSound();
                this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, this.getLevelBasedOnType(), this.getPitchBasedOnType());
                this.setMovementType(MovementType.UP);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.hasTracks(-1) && !this.onGround()) {
                this.playStartSound();
                this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, this.getLevelBasedOnType(), this.getPitchBasedOnType());
                this.setMovementType(MovementType.DOWN);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        this.playStopSound();
        this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, this.getLevelBasedOnType(), this.getPitchBasedOnType());
        this.setMovementType(MovementType.STATIONARY);
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected abstract List<BlockPos> trackPositions();

    protected boolean hasTracks(int yOffset) {
        for (BlockPos pos : this.trackPositions()) {
            if (this.level().getBlockState(pos.offset(0, yOffset, 0)).getBlock() == ModBlocks.POWERED_LIFT_TRACK.get()) continue;
            return false;
        }
        return true;
    }

    public float getCurrentLeverAngle() {
        return this.currentLeverAngle;
    }

    public void setCurrentLeverAngle(float angle) {
        this.currentLeverAngle = angle;
    }

    public void animateHurt(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @NotNull
    protected Component getTypeName() {
        return Component.translatable((String)this.getDropItem().getDescriptionId());
    }

    public boolean canCollideWith(Entity entity) {
        return AbstractLift.canVehicleCollide((Entity)this, entity);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity entity) {
        return (entity.canBeCollidedWith() || entity.isPushable()) && !vehicle.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle portal) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(axis, portal));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void setLeverAngle(AbstractLift entity, ModelPart lever) {
        MovementType movementDirection = entity.getMovementType();
        float targetAngle = switch (movementDirection) {
            case MovementType.UP -> 30.0f;
            case MovementType.DOWN -> -30.0f;
            default -> 0.0f;
        };
        float currentAngle = entity.getCurrentLeverAngle();
        float lerpedAngle = Mth.lerp((float)0.2f, (float)currentAngle, (float)targetAngle);
        entity.setCurrentLeverAngle(lerpedAngle);
        lever.zRot = (float)Math.toRadians(lerpedAngle);
    }

    public static enum Type {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

