/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.util;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.NamedEnum;
import net.neoforged.fml.common.asm.enumextension.NetworkedEnum;
import net.neoforged.fml.common.asm.enumextension.ReservedConstructor;

@NetworkedEnum(value=NetworkedEnum.NetworkCheck.CLIENTBOUND)
@NamedEnum(value=1)
public enum MineralType implements StringRepresentable,
IExtensibleEnum
{
    IRON(Items.IRON_INGOT, "iron"),
    COPPER(Items.COPPER_INGOT, "copper"),
    GOLD(Items.GOLD_INGOT, "gold"),
    DIAMOND(Items.DIAMOND, "diamond"),
    NETHERITE(Items.NETHERITE_INGOT, "netherite");

    private final String name;
    private final Supplier<Item> mineralSupplier;
    final Supplier<Item> entityItem;
    public static final StringRepresentable.EnumCodec<MineralType> CODEC;
    private static final IntFunction<MineralType> BY_ID;

    @ReservedConstructor
    private MineralType(Item mineral, String name) {
        this.name = name;
        this.mineralSupplier = () -> mineral;
        this.entityItem = () -> Items.AIR;
    }

    private MineralType(Supplier<Item> planks, String name, Supplier<Item> boatItem) {
        this.name = name;
        this.mineralSupplier = planks;
        this.entityItem = boatItem;
    }

    public static MineralType getMineralType(ItemStack stack) {
        Item item = stack.getItem();
        for (MineralType type : MineralType.values()) {
            if (item != type.getMineral()) continue;
            return type;
        }
        return null;
    }

    public String getSerializedName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Item getMineral() {
        return this.mineralSupplier.get();
    }

    public String toString() {
        return this.name;
    }

    public static MineralType byId(int id) {
        return BY_ID.apply(id);
    }

    public static MineralType byName(String name) {
        return (MineralType)CODEC.byName(name, (Enum)IRON);
    }

    public static ExtensionInfo getExtensionInfo() {
        return ExtensionInfo.nonExtended(MineralType.class);
    }

    static {
        CODEC = StringRepresentable.fromEnum(MineralType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MineralType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

