/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.util;

import java.util.function.IntFunction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum MovementType implements StringRepresentable
{
    STATIONARY("stationary"),
    UP("up"),
    DOWN("down"),
    FALLING("falling");

    private final String name;
    public static final StringRepresentable.EnumCodec<MovementType> CODEC;
    private static final IntFunction<MovementType> BY_ID;

    private MovementType(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static MovementType byId(int id) {
        return BY_ID.apply(id);
    }

    public static MovementType byName(String name) {
        return (MovementType)CODEC.byName(name, (Enum)STATIONARY);
    }

    static {
        CODEC = StringRepresentable.fromEnum(MovementType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MovementType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

