/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.item.custom;

import java.util.Random;
import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.init.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CandleHelmet
extends ArmorItem {
    private final ResourceLocation TEXTURE = SpelunkersCharm.id("textures/armor/candle_helmet.png");

    public CandleHelmet(Item.Properties properties) {
        super(ArmorMaterials.CHAIN, ArmorItem.Type.HELMET, properties);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return this.TEXTURE;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.getItemBySlot(EquipmentSlot.HEAD) != stack) {
            return;
        }
        this.handleCandleEnvironment(stack, level, living);
        if (this.isCandleLit(stack) && level.isClientSide) {
            this.spawnCandleParticles(level, living);
        }
    }

    private void handleCandleEnvironment(ItemStack stack, Level level, LivingEntity entity) {
        boolean isInWater = entity.isUnderWater();
        boolean isInRain = this.isEntityInRain(entity, level);
        boolean currentlyLit = this.isCandleLit(stack);
        if (currentlyLit && (isInWater || isInRain)) {
            this.extinguishCandle(stack);
            this.playExtinguishSound(level, entity);
        } else if (!(currentlyLit || isInWater || isInRain)) {
            this.relightCandle(stack);
            this.playRelightSound(level, entity);
        }
    }

    private void spawnCandleParticles(Level level, LivingEntity living) {
        Random random = new Random();
        if (random.nextFloat() >= 0.1f) {
            return;
        }
        Vec3 position = living.trackingPosition();
        float yOffset = living.getBbHeight() + 0.25f;
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, position.x, position.y + (double)yOffset, position.z, 0.0, 0.01, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, position.x, position.y + (double)yOffset, position.z, 0.0, 0.01, 0.0);
    }

    private boolean isEntityInRain(LivingEntity entity, Level level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        BlockPos entityPos = entity.blockPosition();
        Biome biome = (Biome)level.getBiome(entityPos).value();
        return level.isRaining() && biome.hasPrecipitation() && level.canSeeSky(entityPos.above()) && level.isRainingAt(entityPos);
    }

    private boolean isCandleLit(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.LIGHT.get(), (Object)true);
    }

    private void extinguishCandle(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.LIGHT.get(), (Object)false);
    }

    private void relightCandle(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.LIGHT.get(), (Object)true);
    }

    private void playExtinguishSound(Level level, LivingEntity entity) {
        if (level.isClientSide) {
            return;
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.8f, 1.2f);
        if (entity.isUnderWater()) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.PLAYERS, 0.4f, 2.0f);
        }
    }

    private void playRelightSound(Level level, LivingEntity entity) {
        if (level.isClientSide) {
            return;
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.PLAYERS, 0.6f, 1.4f);
    }

    public static void toggleCandle(ItemStack stack) {
        boolean currentlyLit = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.LIGHT.get(), (Object)true);
        stack.set((DataComponentType)ModDataComponents.LIGHT.get(), (Object)(!currentlyLit ? 1 : 0));
    }

    public static boolean isCandleHelmetLit(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.LIGHT.get(), (Object)true);
    }

    public static void extinguishCandleHelmet(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.LIGHT.get(), (Object)false);
    }

    public static void lightCandleHelmet(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.LIGHT.get(), (Object)true);
    }
}

