/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen;

import java.util.List;
import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.datagen.biomes.biomeTags.ModBiomeTags;
import net.luckystudio.spelunkers_charm.worldgen.feature.placement.ModCavePlacements;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModBiomeModifier {
    public static final ResourceKey<BiomeModifier> OVERWORLD_UNDERGROUND_DECORATION = ModBiomeModifier.registerKey("overworld_underground_decoration");
    public static final ResourceKey<BiomeModifier> ICE_CAVE_UNDERGROUND_DECORATION = ModBiomeModifier.registerKey("ice_cave_vegetal_decoration");
    public static final ResourceKey<BiomeModifier> DESERT_CAVE_UNDERGROUND_DECORATION = ModBiomeModifier.registerKey("desert_cave_vegetal_decoration");
    public static final ResourceKey<BiomeModifier> JUNGLE_CAVE_UNDERGROUND_DECORATION = ModBiomeModifier.registerKey("jungle_cave_vegetal_decoration");
    public static final ResourceKey<BiomeModifier> NETHER_UNDERGROUND_DECORATION = ModBiomeModifier.registerKey("nether_vegetal_decoration");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(OVERWORLD_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct(List.of(placedFeatures.getOrThrow(ModCavePlacements.DEEPSLATE_LAVA_GEYSER), placedFeatures.getOrThrow(ModCavePlacements.CLAY_PILE), placedFeatures.getOrThrow(ModCavePlacements.ROCK_PILE), placedFeatures.getOrThrow(ModCavePlacements.DEEPSLATE_ROCK_PILE), placedFeatures.getOrThrow(ModCavePlacements.DRIPSTONE_ROCK_PILE), placedFeatures.getOrThrow(ModCavePlacements.PATCH_CAVE_MUSHROOM), placedFeatures.getOrThrow(ModCavePlacements.BOULDERS))), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(ICE_CAVE_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModBiomeTags.IS_COLD_CAVE), (HolderSet)HolderSet.direct(List.of(placedFeatures.getOrThrow(ModCavePlacements.PERMAFROST), placedFeatures.getOrThrow(ModCavePlacements.ORE_SILT), placedFeatures.getOrThrow(ModCavePlacements.ICE_PILE), placedFeatures.getOrThrow(ModCavePlacements.LARGE_ICICLE), placedFeatures.getOrThrow(ModCavePlacements.ICICLE_CLUSTER), placedFeatures.getOrThrow(ModCavePlacements.BOTTOM_ICE_SHEET))), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(DESERT_CAVE_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModBiomeTags.IS_HOT_CAVE), (HolderSet)HolderSet.direct(List.of(placedFeatures.getOrThrow(ModCavePlacements.DUNESTONE))), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(JUNGLE_CAVE_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModBiomeTags.IS_JUNGLE_CAVE), (HolderSet)HolderSet.direct(List.of(placedFeatures.getOrThrow(ModCavePlacements.WILDSTONE), placedFeatures.getOrThrow(ModCavePlacements.NEW_LUSH_VEGETATION), placedFeatures.getOrThrow(CavePlacements.LUSH_CAVES_CEILING_VEGETATION))), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(NETHER_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_NETHER), (HolderSet)HolderSet.direct(List.of(placedFeatures.getOrThrow(ModCavePlacements.BASALT_ROCK_PILE))), GenerationStep.Decoration.UNDERGROUND_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)SpelunkersCharm.id(name));
    }
}

