/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.boulder;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.luckystudio.spelunkers_charm.SpelunkersCharmConfig;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderBlock;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderType;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderUtils;
import net.luckystudio.spelunkers_charm.block.util.enums.BlockPart;
import net.luckystudio.spelunkers_charm.datagen.biomes.biomeTags.ModBiomeTags;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BoulderFeature
extends Feature<NoneFeatureConfiguration> {
    public BoulderFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BoulderType boulderType;
        if (!((Boolean)SpelunkersCharmConfig.BOULDERS.get()).booleanValue()) {
            return false;
        }
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin().above();
        Random random = new Random();
        boolean isLushCave = world.getBiome(origin).is(ModBiomeTags.IS_JUNGLE_CAVE) || world.getBiome(origin).getKey() == Biomes.LUSH_CAVES;
        boolean isFrozenCave = world.getBiome(origin).is(ModBiomeTags.IS_COLD_CAVE) && world.getBiome(origin).getKey() != Biomes.DRIPSTONE_CAVES;
        boolean isBelowZero = origin.getY() < 0;
        float goldWeight = isBelowZero ? 0.25f : 0.1f;
        float ironWeight = 0.3f;
        float copperWeight = 0.3f;
        float regularWeight = 1.0f;
        float total = goldWeight + ironWeight + copperWeight + regularWeight;
        float random2 = random.nextFloat() * total;
        if (random2 < goldWeight) {
            boulderType = isLushCave ? BoulderType.LUSH_GOLD : BoulderType.GOLD;
        } else {
            float f;
            random2 -= goldWeight;
            boulderType = f < ironWeight ? (isLushCave ? BoulderType.LUSH_IRON : BoulderType.IRON) : (random2 - ironWeight < copperWeight ? (isLushCave ? BoulderType.LUSH_COPPER : BoulderType.COPPER) : (isLushCave ? BoulderType.LUSH : BoulderType.STONE));
        }
        BlockState boulderProviderState = BoulderUtils.getBoulderFromType(boulderType);
        BlockState surroundingBlockState = isBelowZero ? Blocks.COBBLED_DEEPSLATE.defaultBlockState() : (isLushCave ? Blocks.MOSS_BLOCK.defaultBlockState() : (isFrozenCave ? Blocks.BLUE_ICE.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
        Direction direction = Direction.NORTH;
        this.setBlock((LevelWriter)world, origin, (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_MIDDLE)));
        this.setBlock((LevelWriter)world, origin.relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_SIDE)));
        this.setBlock((LevelWriter)world, origin.relative(direction).relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_CORNER)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_SIDE)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getClockWise()).relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_CORNER)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_SIDE)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getOpposite()).relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_CORNER)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_SIDE)));
        this.setBlock((LevelWriter)world, origin.relative(direction.getCounterClockWise()).relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_CORNER)));
        this.setBlock((LevelWriter)world, origin.above(), BoulderUtils.getRawCore(boulderType).defaultBlockState());
        this.setBlock((LevelWriter)world, origin.above().relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_SIDE)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction).relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_CORNER)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_SIDE)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getClockWise()).relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_CORNER)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_SIDE)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getOpposite()).relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_CORNER)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_SIDE)));
        this.setBlock((LevelWriter)world, origin.above().relative(direction.getCounterClockWise()).relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.MIDDLE_CORNER)));
        this.setBlock((LevelWriter)world, origin.above(2), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_MIDDLE)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_SIDE)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction).relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_CORNER)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_SIDE)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getClockWise()).relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_CORNER)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getOpposite()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_SIDE)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getOpposite()).relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_CORNER)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getCounterClockWise()), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_SIDE)));
        this.setBlock((LevelWriter)world, origin.above(2).relative(direction.getCounterClockWise()).relative(direction), (BlockState)((BlockState)boulderProviderState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getCounterClockWise())).setValue(BoulderBlock.BLOCK_PART, (Comparable)((Object)BlockPart.TOP_CORNER)));
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos = origin.offset(x, -1, z);
                if (!world.getBlockState(pos).canBeReplaced() && !world.getBlockState(pos).is(BlockTags.AZALEA_ROOT_REPLACEABLE)) continue;
                this.setBlock((LevelWriter)world, pos, surroundingBlockState);
            }
        }
        return true;
    }

    private BlockState getCore(BlockState boulderProviderState) {
        if (boulderProviderState.getBlock() == ModBlocks.COPPER_BOULDER.get()) {
            return Blocks.RAW_COPPER_BLOCK.defaultBlockState();
        }
        if (boulderProviderState.getBlock() == ModBlocks.GOLD_BOULDER.get()) {
            return Blocks.RAW_GOLD_BLOCK.defaultBlockState();
        }
        return Blocks.RAW_IRON_BLOCK.defaultBlockState();
    }
}

