/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.icicle;

import java.util.function.Consumer;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class IcicleBlockUtil {
    protected static void buildBaseToTipColumn(Direction direction, int height, boolean mergeTip, Consumer<BlockState> blockSetter) {
        if (height >= 3) {
            blockSetter.accept(IcicleBlockUtil.createIcicle(direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                blockSetter.accept(IcicleBlockUtil.createIcicle(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            blockSetter.accept(IcicleBlockUtil.createIcicle(direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            blockSetter.accept(IcicleBlockUtil.createIcicle(direction, mergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    public static void growPointedIcicle(LevelAccessor level, BlockPos pos, Direction direction, int height, boolean mergeTip) {
        if (IcicleBlockUtil.isIcicleBase(level.getBlockState(pos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
            IcicleBlockUtil.buildBaseToTipColumn(direction, height, mergeTip, blockState -> {
                if (blockState.is((Block)ModBlocks.ICICLE.get())) {
                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt((BlockPos)blockpos$mutableblockpos)));
                }
                level.setBlock((BlockPos)blockpos$mutableblockpos, blockState, 2);
                blockpos$mutableblockpos.move(direction);
            });
        }
    }

    public static boolean placeIcicleBlockIfPossible(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(ModBlocks.PERMAFROST)) {
            level.setBlock(pos, Blocks.PACKED_ICE.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    public static BlockState createIcicle(Direction direction, DripstoneThickness dripstoneThickness) {
        return (BlockState)((BlockState)((Block)ModBlocks.ICICLE.get()).defaultBlockState().setValue((Property)BlockStateProperties.VERTICAL_DIRECTION, (Comparable)direction)).setValue((Property)BlockStateProperties.DRIPSTONE_THICKNESS, (Comparable)dripstoneThickness);
    }

    public static boolean isIcicleBase(BlockState state) {
        return state.is(Blocks.PACKED_ICE) || state.is(ModBlocks.PERMAFROST);
    }

    public static boolean isEmptyOrWater(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, IcicleBlockUtil::isEmptyOrWater);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(BlockState state) {
        return !state.isAir() && !state.is(Blocks.WATER);
    }

    public static boolean isIcicleBaseOrLava(BlockState state) {
        return IcicleBlockUtil.isIcicleBase(state) || state.is(Blocks.LAVA);
    }

    public static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel level, BlockPos pos, int radius) {
        if (IcicleBlockUtil.isEmptyOrWaterOrLava((LevelAccessor)level, pos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)radius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.cos((float)f2) * (float)radius);
            if (!IcicleBlockUtil.isEmptyOrWaterOrLava((LevelAccessor)level, pos.offset(i, 0, j = (int)(Mth.sin((float)f2) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrWaterOrLava(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, IcicleBlockUtil::isEmptyOrWaterOrLava);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }

    public static double getIcicleHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double d0 = 0.384;
        double d1 = radius / maxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = scale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * maxRadius;
    }
}

