/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.packed_ice_cluster;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.icicle.IcicleBlockUtil;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.packed_ice_cluster.IcicleClusterConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IcicleClusterFeature
extends Feature<IcicleClusterConfiguration> {
    public IcicleClusterFeature(Codec<IcicleClusterConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<IcicleClusterConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        BlockPos blockpos = context.origin();
        IcicleClusterConfiguration config = (IcicleClusterConfiguration)context.config();
        RandomSource randomsource = context.random();
        if (!IcicleBlockUtil.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        int i = config.height.sample(randomsource);
        float f = config.wetness.sample(randomsource);
        float f1 = config.density.sample(randomsource);
        int j = config.radius.sample(randomsource);
        int k = config.radius.sample(randomsource);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, config);
                BlockPos blockpos1 = blockpos.offset(l, 0, i1);
                this.placeColumn(worldgenlevel, randomsource, blockpos1, l, i1, f, d0, i, f1, config);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel level, RandomSource random, BlockPos pos, int x, int z, float wetness, double chance, int height, float density, IcicleClusterConfiguration config) {
        Optional optional = Column.scan((LevelSimulatedReader)level, (BlockPos)pos, (int)config.floorToCeilingSearchRange, IcicleBlockUtil::isEmptyOrWater, IcicleBlockUtil::isNeitherEmptyNorWater);
        if (!optional.isEmpty()) {
            OptionalInt optionalint = ((Column)optional.get()).getCeiling();
            OptionalInt optionalint1 = ((Column)optional.get()).getFloor();
            if (!optionalint.isEmpty() || !optionalint1.isEmpty()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = random.nextFloat() < wetness;
                if (flag && optionalint1.isPresent() && this.canPlacePool(level, pos.atY(optionalint1.getAsInt()))) {
                    int i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).withFloor(OptionalInt.of(i - 1));
                    level.setBlock(pos.atY(i), Blocks.WATER.defaultBlockState(), 2);
                } else {
                    column = (Column)optional.get();
                }
                OptionalInt optionalint2 = column.getFloor();
                boolean bl2 = flag1 = random.nextDouble() < chance;
                if (optionalint.isPresent() && flag1 && !this.isLava((LevelReader)level, pos.atY(optionalint.getAsInt()))) {
                    int k = config.icicleBlockLayerThickness.sample(random);
                    this.replaceBlocksWithBlocks(level, pos.atY(optionalint.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(height, optionalint.getAsInt() - optionalint2.getAsInt()) : height;
                    j = this.getIcicleHeight(random, x, z, density, l, config);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = random.nextDouble() < chance;
                if (optionalint2.isPresent() && flag2 && !this.isLava((LevelReader)level, pos.atY(optionalint2.getAsInt()))) {
                    int i1 = config.icicleBlockLayerThickness.sample(random);
                    this.replaceBlocksWithBlocks(level, pos.atY(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalint.isPresent() ? Math.max(0, j + Mth.randomBetweenInclusive((RandomSource)random, (int)(-config.maxStalagmiteStalactiteHeightDiff), (int)config.maxStalagmiteStalactiteHeightDiff)) : this.getIcicleHeight(random, x, z, density, height, config);
                } else {
                    i3 = 0;
                }
                if (optionalint.isPresent() && optionalint2.isPresent() && optionalint.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalint.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.randomBetweenInclusive((RandomSource)random, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = random.nextBoolean() && j3 > 0 && j1 > 0 && column.getHeight().isPresent() && j3 + j1 == column.getHeight().getAsInt();
                if (optionalint.isPresent()) {
                    IcicleBlockUtil.growPointedIcicle((LevelAccessor)level, pos.atY(optionalint.getAsInt() - 1), Direction.DOWN, j3, flag3);
                }
                if (optionalint2.isPresent()) {
                    IcicleBlockUtil.growPointedIcicle((LevelAccessor)level, pos.atY(optionalint2.getAsInt() + 1), Direction.UP, j1, flag3);
                }
            }
        }
    }

    private boolean isLava(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos).is(Blocks.LAVA);
    }

    private int getIcicleHeight(RandomSource random, int x, int z, float chance, int height, IcicleClusterConfiguration config) {
        if (random.nextFloat() > chance) {
            return 0;
        }
        int i = Math.abs(x) + Math.abs(z);
        float f = (float)Mth.clampedMap((double)i, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.randomBetweenBiased(random, 0.0f, height, f, config.heightDeviation);
    }

    private boolean canPlacePool(WorldGenLevel level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (!(blockstate.is(Blocks.WATER) || blockstate.is(Blocks.PACKED_ICE) || blockstate.is(ModBlocks.ICICLE))) {
            if (level.getBlockState(pos.above()).getFluidState().is(FluidTags.WATER)) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)level, pos.relative(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)level, pos.below());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.is(BlockTags.BASE_STONE_OVERWORLD) || blockstate.getFluidState().is(FluidTags.WATER);
    }

    private void replaceBlocksWithBlocks(WorldGenLevel level, BlockPos pos, int thickness, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 0; i < thickness; ++i) {
            if (!IcicleBlockUtil.placeIcicleBlockIfPossible((LevelAccessor)level, (BlockPos)blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.move(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int xRadius, int zRadius, int x, int z, IcicleClusterConfiguration config) {
        int i = xRadius - Math.abs(x);
        int j = zRadius - Math.abs(z);
        int k = Math.min(i, j);
        return Mth.clampedMap((float)k, (float)0.0f, (float)config.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, (float)config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float randomBetweenBiased(RandomSource random, float min, float max, float mean, float deviation) {
        return ClampedNormalFloat.sample((RandomSource)random, (float)mean, (float)deviation, (float)min, (float)max);
    }
}

