/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom;

import com.mojang.serialization.MapCodec;
import net.luckystudio.spelunkers_charm.block.custom.WoodenLiftTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredLiftTrackBlock
extends WoodenLiftTrackBlock {
    public static final MapCodec<PoweredLiftTrackBlock> CODEC = PoweredLiftTrackBlock.simpleCodec(PoweredLiftTrackBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private int distance = 7;

    public PoweredLiftTrackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        boolean isPowered = context.getLevel().hasNeighborSignal(context.getClickedPos()) || this.findTrackWithSignal(level, pos, state, true) || this.findTrackWithSignal(level, pos, state, false);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered || context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (!(levelAccessor instanceof Level)) {
            return state;
        }
        Level level = (Level)levelAccessor;
        boolean isPowered = level.hasNeighborSignal(pos) || this.findTrackWithSignal(level, pos, state, true) || this.findTrackWithSignal(level, pos, state, false);
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
    }

    protected boolean findTrackWithSignal(Level level, BlockPos pos, BlockState state, boolean searchUp) {
        Direction dir = searchUp ? Direction.UP : Direction.DOWN;
        BlockPos.MutableBlockPos currentPos = pos.mutable();
        for (int i = 1; i <= this.distance; ++i) {
            currentPos.move(dir);
            BlockState currentState = level.getBlockState((BlockPos)currentPos);
            if (!currentState.is((Block)this)) {
                return false;
            }
            if (!level.getBlockState((BlockPos)currentPos).is((Block)this)) {
                return false;
            }
            if (level.getBestNeighborSignal((BlockPos)currentPos) <= 0) continue;
            return true;
        }
        return false;
    }
}

