/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class SpiderEgg
extends RodBlock {
    public static final MapCodec<SpiderEgg> CODEC = SpiderEgg.simpleCodec(SpiderEgg::new);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockState -> switch ((Integer)blockState.getValue((Property)HATCH)) {
        case 1 -> 5;
        case 2 -> 7;
        default -> 3;
    };
    private static final VoxelShape NORTH = Block.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0);
    private static final VoxelShape SOUTH = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)14.0);
    private static final VoxelShape WEST = Block.box((double)2.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final VoxelShape DOWN = Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SpiderEgg(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<SpiderEgg> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        boolean flag = SpiderEgg.hatchBoost((BlockGetter)level, pos);
        if (!level.isClientSide() && flag) {
            level.levelEvent(3009, pos, 0);
        }
        int i = flag ? 12000 : 24000;
        int j = i / 3;
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((BlockState)state));
        level.scheduleTick(pos, (Block)this, j + level.random.nextInt(300));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.destroyEgg(level, state, pos, entity, 100);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3);
        }
        super.fallOn(level, state, pos, entity, fallDistance);
    }

    private void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance) {
        if (this.canDestroyEgg(level, entity) && !level.isClientSide && level.random.nextInt(chance) == 0 && state.is(ModBlocks.SPIDER_EGG)) {
            level.playSound(null, pos, ModSoundEvents.SPIDER_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
            level.destroyBlock(pos, false);
        }
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (entity instanceof Turtle || entity instanceof Bat) {
            return false;
        }
        return entity instanceof LivingEntity && (entity instanceof Player || EventHooks.canEntityGrief((Level)level, (Entity)entity));
    }

    public int getHatchLevel(BlockState state) {
        return (Integer)state.getValue((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState state) {
        return this.getHatchLevel(state) == 2;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean playerNearby;
        boolean bl = playerNearby = !level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(8.0)).isEmpty();
        if (!playerNearby) {
            return;
        }
        if (!this.isReadyToHatch(state)) {
            level.playSound(null, pos, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
            level.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
            level.getChunk(pos).setUnsaved(true);
            level.getChunkSource().getLightEngine().checkBlock(pos);
        } else {
            this.hatch(level, pos, random);
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos;
        if (!level.isClientSide && projectile.mayInteract(level, blockpos = hit.getBlockPos()) && projectile.mayBreak(level) && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockpos, true);
            if ((Integer)state.getValue((Property)HATCH) == 2) {
                Random random = new Random();
                RandomSource randomSource = RandomSource.create((long)random.nextLong());
                this.hatch((ServerLevel)level, blockpos, randomSource);
            }
        }
    }

    private void hatch(ServerLevel level, BlockPos pos, RandomSource random) {
        level.playSound(null, pos, ModSoundEvents.SPIDER_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
        level.destroyBlock(pos, false);
        CaveSpider caveSpider = (CaveSpider)EntityType.CAVE_SPIDER.create((Level)level);
        if (caveSpider != null) {
            Vec3 vec3 = pos.getCenter();
            caveSpider.setBaby(true);
            caveSpider.moveTo(vec3.x(), vec3.y(), vec3.z(), Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
            level.addFreshEntity((Entity)caveSpider);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static boolean hatchBoost(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(BlockTags.SNIFFER_EGG_HATCH_BOOST);
    }
}

