/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.boulder;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderBlock;
import net.luckystudio.spelunkers_charm.block.custom.boulder.HangingType;
import net.luckystudio.spelunkers_charm.init.ModStructureProcessorType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BlockStateProcessor
extends StructureProcessor {
    public static final MapCodec<BlockStateProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HangingType.CODEC.fieldOf("hanging_type").forGetter(p -> p.hangingType)).apply((Applicative)instance, BlockStateProcessor::new));
    private final HangingType hangingType;

    public BlockStateProcessor(HangingType hangingType) {
        this.hangingType = hangingType;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings settings) {
        BlockState state = currentBlockInfo.state();
        if (state.getBlock() instanceof BoulderBlock) {
            state = (BlockState)state.setValue(BoulderBlock.HANGING_TYPE, (Comparable)((Object)this.hangingType));
            return new StructureTemplate.StructureBlockInfo(currentBlockInfo.pos(), state, currentBlockInfo.nbt());
        }
        return currentBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return ModStructureProcessorType.BOULDER_STATE.get();
    }
}

