/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.boulder.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.SpelunkersCharmClient;
import net.luckystudio.spelunkers_charm.block.custom.boulder.entity.Boulder;
import net.luckystudio.spelunkers_charm.block.custom.boulder.entity.BoulderModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class BoulderRenderer<T extends Boulder>
extends EntityRenderer<Boulder> {
    private static final ResourceLocation BOULDER_LOCATION = SpelunkersCharm.id("textures/entity/boulder/boulder.png");
    private static final ResourceLocation LUSH_BOULDER_LOCATION = SpelunkersCharm.id("textures/entity/boulder/lush_boulder.png");
    EntityModel<T> boulderModel;

    public BoulderRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.boulderModel = new BoulderModel(context.bakeLayer(SpelunkersCharmClient.BOULDER));
    }

    public ResourceLocation getTextureLocation(Boulder entity) {
        return entity.getBoulderType().ordinal() < 4 ? BOULDER_LOCATION : LUSH_BOULDER_LOCATION;
    }

    public void render(Boulder entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.5f, 0.0f);
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        VertexConsumer woodVertexConsumer = buffer.getBuffer(this.boulderModel.renderType(this.getTextureLocation(entity)));
        this.boulderModel.renderToBuffer(poseStack, woodVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

