/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.util;

import java.util.function.IntFunction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum ControlType implements StringRepresentable
{
    AUTOMATIC("automatic"),
    LEVER("lever"),
    PRESSURE_PLATE("pressure_plate");

    private final String name;
    public static final StringRepresentable.EnumCodec<ControlType> CODEC;
    private static final IntFunction<ControlType> BY_ID;

    private ControlType(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static ControlType byId(int id) {
        return BY_ID.apply(id);
    }

    public static ControlType byName(String name) {
        return (ControlType)CODEC.byName(name, (Enum)AUTOMATIC);
    }

    static {
        CODEC = StringRepresentable.fromEnum(ControlType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ControlType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

