/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.events.tremor.Tremor;
import net.luckystudio.spelunkers_charm.events.tremor.TremorManager;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.item.potion.ModPotions;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="spelunkers_charm", bus=EventBusSubscriber.Bus.GAME)
public class GameEvents {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)Component.translatable((String)"command.spelunkers_charm.tremor").getString()).requires(s -> s.hasPermission(4))).then(Commands.literal((String)Component.translatable((String)"command.spelunkers_charm.tremor.start").getString()).then(Commands.argument((String)Component.translatable((String)"command.spelunkers_charm.tremor.lengthInSeconds").getString(), (ArgumentType)IntegerArgumentType.integer((int)5, (int)100)).then(Commands.argument((String)Component.translatable((String)"command.spelunkers_charm.tremor.intensity").getString(), (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> {
            GameEvents.runTremorStart((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))))).then(Commands.literal((String)Component.translatable((String)"command.spelunkers_charm.tremor.stop").getString()).executes(ctx -> {
            GameEvents.runTremorStop((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(Commands.literal((String)Component.translatable((String)"command.spelunkers_charm.tremor.help").getString()).executes(ctx -> {
            GameEvents.runTremorHelp((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })));
    }

    private static void runTremorStart(CommandContext<CommandSourceStack> ctx) {
        Level level = ((CommandSourceStack)ctx.getSource()).getUnsidedLevel();
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        assert (entity != null);
        BlockPos blockPos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
        int length = (Integer)ctx.getArgument(Component.translatable((String)"command.spelunkers_charm.tremor.lengthInSeconds").getString(), Integer.class);
        int intensity = (Integer)ctx.getArgument(Component.translatable((String)"command.spelunkers_charm.tremor.intensity").getString(), Integer.class);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.displayClientMessage((Component)Component.translatable((String)"command.spelunkers_charm.tremor.start.message"), false);
        }
        TremorManager.spawnTremor(level, blockPos, length * 20, intensity, 1.0f, true);
    }

    private static void runTremorStop(CommandContext<CommandSourceStack> ctx) {
        Level level = ((CommandSourceStack)ctx.getSource()).getUnsidedLevel();
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        assert (entity != null);
        BlockPos blockPos = entity.blockPosition();
        int radius = 64;
        List tremors = level.getEntitiesOfClass(Tremor.class, new AABB(blockPos).inflate((double)radius));
        for (Tremor tremor : tremors) {
            tremor.discard();
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.displayClientMessage((Component)Component.translatable((String)"command.spelunkers_charm.tremor.stop.message", (Object[])new Object[]{tremors.size()}), false);
        }
    }

    private static void runTremorHelp(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.spelunkers_charm.tremor.help.message"), false);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == Items.MINECART) {
            event.getToolTip().add(Component.translatable((String)"tooltip.spelunkers_charm.minecart").withStyle(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, ModBlocks.CAVE_MUSHROOM.asItem(), ModPotions.HASTE_POTION);
        builder.addMix(ModPotions.HASTE_POTION, Items.REDSTONE, ModPotions.LONG_HASTE_POTION);
        builder.addMix(ModPotions.HASTE_POTION, Items.GLOWSTONE_DUST, ModPotions.STRONG_HASTE_POTION);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static ItemInteractionResult onUseClayBallOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        BlockPos offset = event.getPos().relative(Objects.requireNonNull(event.getFace()));
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (stack.getItem() != Items.CLAY_BALL) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (event.getHand().equals((Object)InteractionHand.OFF_HAND)) {
            return ItemInteractionResult.FAIL;
        }
        if (state.is((Block)ModBlocks.CLAY_PILE.get()) && (Integer)state.getValue((Property)ModBlockStateProperties.ROCKS) < 3) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ModBlockStateProperties.ROCKS), 3);
            GameEvents.useClayBall(player, level, pos, stack, hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isCrouching() && level.getBlockState(offset).canBeReplaced() && ((Block)ModBlocks.CLAY_PILE.get()).defaultBlockState().canSurvive((LevelReader)level, offset)) {
            level.setBlock(offset, ((Block)ModBlocks.CLAY_PILE.get()).defaultBlockState(), 3);
            GameEvents.useClayBall(player, level, pos, stack, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void useClayBall(@NotNull Player player, Level level, BlockPos pos, ItemStack stack, InteractionHand hand) {
        level.playSound(null, pos, SoundEvents.WET_GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.awardStat(Stats.ITEM_USED.get((Object)Items.CLAY_BALL));
        stack.consume(1, (LivingEntity)player);
        player.swing(hand);
    }
}

