/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events.tremor;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.luckystudio.spelunkers_charm.SpelunkersCharmConfig;
import net.luckystudio.spelunkers_charm.datagen.biomes.biomeTags.ModBiomeTags;
import net.luckystudio.spelunkers_charm.events.tremor.Tremor;
import net.luckystudio.spelunkers_charm.events.tremor.TremorBlockPosEvents;
import net.luckystudio.spelunkers_charm.init.ModEntityType;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TremorManager {
    public static void spawnTremor(Level level, BlockPos pos, int length, int intensity, float chance, boolean forceSpawn) {
        if (forceSpawn || TremorManager.canTremor(level, pos)) {
            AABB searchBox = new AABB(pos).inflate(64.0);
            List players = level.getEntitiesOfClass(ServerPlayer.class, searchBox);
            List tremors = level.getEntitiesOfClass(Tremor.class, searchBox);
            if (!tremors.isEmpty()) {
                for (Tremor tremor : tremors) {
                    tremor.setLength(tremor.getLength() + length);
                    if (intensity <= tremor.getMagnitude()) continue;
                    tremor.setMagnitude(tremor.getMagnitude() + intensity);
                }
            } else {
                for (ServerPlayer player : players) {
                    if (!(player.getRandom().nextFloat() < chance)) continue;
                    player.playNotifySound(TremorManager.getRumbleSound(player), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                Tremor tremor = new Tremor(ModEntityType.TREMOR.get(), level);
                tremor.setLength(length);
                tremor.setMagnitude(intensity);
                tremor.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)tremor);
            }
        }
    }

    static boolean canTremor(Level level, BlockPos pos) {
        if (!((Boolean)SpelunkersCharmConfig.TREMORS.get()).booleanValue()) {
            return false;
        }
        if (level.dimension() != Level.OVERWORLD || level.canSeeSky(pos)) {
            return false;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        ResourceKey biomeKey = level.getBiome(pos).getKey();
        if (biomeKey == null) {
            return false;
        }
        return !level.getBiome(pos).is(ModBiomeTags.NO_TREMORS);
    }

    public static void tremorTick(Tremor tremor) {
        int soundInterval;
        Level level = tremor.level();
        BlockPos pos = tremor.blockPosition();
        if (!TremorManager.tremorShouldDieDown(tremor) && tremor.getMagnitude() < 120) {
            tremor.incrementIntensity();
        }
        if (TremorManager.tremorShouldDieDown(tremor) && tremor.getMagnitude() > 0) {
            tremor.decrementIntensity();
        }
        int repeatCount = tremor.getMagnitude() + 2;
        SoundEvent tremorSound = TremorManager.getTremorSound(level, pos);
        int n = soundInterval = tremorSound == ModSoundEvents.TREMOR_ICY ? 80 : 40;
        if (tremor.tickCount % soundInterval == 0) {
            float pitch = 0.75f + level.random.nextFloat() * 0.5f;
            level.playSound(null, pos, TremorManager.getTremorSound(level, pos), SoundSource.AMBIENT, 0.75f, pitch);
        }
        for (int i = 0; i < repeatCount; ++i) {
            Optional<BlockPos> validTopEffectPos = TremorManager.findValidEffectPos(level, pos, Direction.UP);
            Optional<BlockPos> validBottomEffectPos = TremorManager.findValidEffectPos(level, pos, Direction.DOWN);
            validTopEffectPos.ifPresent(blockPos -> TremorBlockPosEvents.topEffectPos(level, blockPos));
            validBottomEffectPos.ifPresent(blockPos -> TremorBlockPosEvents.bottomEffectPos(level, blockPos));
        }
    }

    public static boolean tremorShouldDieDown(Tremor tremor) {
        return tremor.getLifetime() >= tremor.getLength() - 120;
    }

    public static Optional<BlockPos> findValidEffectPos(Level level, BlockPos playerPos, Direction direction) {
        Random random = new Random();
        int offsetX = random.nextInt(65) - 32;
        int offsetY = random.nextInt(33) - 16;
        int offsetZ = random.nextInt(65) - 32;
        BlockPos randomPos = playerPos.offset(offsetX, offsetY, offsetZ);
        BlockPos.MutableBlockPos searchPos = randomPos.mutable();
        for (int i = 0; i <= 48; ++i) {
            BlockPos adjacent;
            BlockState adjacentState;
            searchPos.move(direction);
            BlockState blockState = level.getBlockState((BlockPos)searchPos);
            if (blockState.isAir() || blockState.canBeReplaced()) continue;
            Block block = blockState.getBlock();
            if (block instanceof PointedDripstoneBlock) {
                PointedDripstoneBlock dripstone = (PointedDripstoneBlock)block;
                DripstoneThickness thickness = (DripstoneThickness)blockState.getValue((Property)PointedDripstoneBlock.THICKNESS);
                if (thickness != DripstoneThickness.BASE) continue;
            }
            if (!(adjacentState = level.getBlockState(adjacent = searchPos.relative(direction.getOpposite()))).isAir()) continue;
            return Optional.of(searchPos.immutable());
        }
        return Optional.empty();
    }

    private static SoundEvent getRumbleSound(ServerPlayer serverPlayer) {
        Level level = serverPlayer.level();
        Holder biomeKey = level.getBiome(serverPlayer.blockPosition());
        if (biomeKey.is(ModBiomeTags.IS_COLD_CAVE)) {
            return ModSoundEvents.RUMBLE_ICY.get();
        }
        return ModSoundEvents.RUMBLE_GENERIC.get();
    }

    private static SoundEvent getTremorSound(Level level, BlockPos pos) {
        Holder biomeKey = level.getBiome(pos);
        if (biomeKey.is(ModBiomeTags.IS_COLD_CAVE)) {
            return ModSoundEvents.TREMOR_ICY.get();
        }
        return ModSoundEvents.TREMOR_GENERIC.get();
    }
}

