/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.item.custom;

import net.luckystudio.spelunkers_charm.entity.custom.rock.DeepslateRock;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class DeepslateRockItem
extends BlockItem
implements ProjectileItem {
    public DeepslateRockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITCH_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            DeepslateRock deepslateRock = new DeepslateRock(level, (LivingEntity)player);
            deepslateRock.setItem(itemstack);
            deepslateRock.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
            level.addFreshEntity((Entity)deepslateRock);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @NotNull
    public Projectile asProjectile(@NotNull Level level, Position pos, @NotNull ItemStack stack, @NotNull Direction direction) {
        DeepslateRock deepslateRock = new DeepslateRock(level, pos.x(), pos.y(), pos.z());
        deepslateRock.setItem(stack);
        return deepslateRock;
    }
}

