/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.item.custom;

import java.util.List;
import java.util.Objects;
import net.luckystudio.spelunkers_charm.entity.custom.lift.AbstractLift;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class LiftItem
extends Item {
    final AbstractLift.Type type;

    public LiftItem(AbstractLift.Type type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        ItemStack itemstack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            AbstractLift abstractLift = AbstractLift.createLift(serverlevel, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 1.0, (double)blockpos.getZ() + 0.5, this.type, itemstack, context.getPlayer());
            Direction facing = Objects.requireNonNull(context.getPlayer()).getDirection();
            abstractLift.setYRot(facing.toYRot());
            if (!serverlevel.noCollision((Entity)abstractLift, abstractLift.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            serverlevel.addFreshEntity((Entity)abstractLift);
            serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)serverlevel.getBlockState(blockpos.below())));
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.spelunkers_charm.lift_item"));
    }
}

