/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.biomes;

import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.luckystudio.spelunkers_charm.worldgen.biomes.ModBiomes;
import net.luckystudio.spelunkers_charm.worldgen.feature.placement.ModCavePlacements;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModBiomeData {
    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter holdergetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter holdergetter1 = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(ModBiomes.SPIDER_CAVE, (Object)ModBiomeData.spiderCave((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
    }

    public static Biome spiderCave(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        spawnSettings.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.GLOW_SQUID, 10, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        ModBiomeData.globalOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        ModBiomeData.addSpiderCaveVegetation(generationSettings);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(7907327).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).ambientAdditionsSound(new AmbientAdditionsSettings(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)ModSoundEvents.SPIDER_CAVE_ADDITIONS.get()), 0.0016)).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)generationSettings);
    }

    public static void addSpiderCaveVegetation(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModCavePlacements.SPIDER_CAVE_CEILING_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModCavePlacements.WEB_PATCH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModCavePlacements.WEB_VEIN);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModCavePlacements.SPIDER_EGG);
    }

    protected static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(boolean hasPercipitation, float temperature, float downfall, MobSpawnSettings.Builder mobSpawnSettings, BiomeGenerationSettings.Builder generationSettings, @Nullable Music backgroundMusic) {
        return ModBiomeData.biome(hasPercipitation, temperature, downfall, 4159204, 329011, null, null, mobSpawnSettings, generationSettings, backgroundMusic);
    }

    private static Biome biome(boolean hasPrecipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColorOverride, @Nullable Integer foliageColorOverride, MobSpawnSettings.Builder mobSpawnSettings, BiomeGenerationSettings.Builder generationSettings, @Nullable Music backgroundMusic) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).skyColor(ModBiomeData.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(backgroundMusic);
        if (grassColorOverride != null) {
            biomespecialeffects$builder.grassColorOverride(grassColorOverride.intValue());
        }
        if (foliageColorOverride != null) {
            biomespecialeffects$builder.foliageColorOverride(foliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(hasPrecipitation).temperature(temperature).downfall(downfall).specialEffects(biomespecialeffects$builder.build()).mobSpawnSettings(mobSpawnSettings.build()).generationSettings(generationSettings.build()).build();
    }
}

