/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.geyser;

import com.mojang.serialization.Codec;
import net.luckystudio.spelunkers_charm.SpelunkersCharmConfig;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.geyser.GeyserConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class GeyserFeature
extends Feature<GeyserConfiguration> {
    public GeyserFeature(Codec<GeyserConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<GeyserConfiguration> context) {
        BlockPos blockpos;
        if (!((Boolean)SpelunkersCharmConfig.GEYSERS.get()).booleanValue()) {
            return false;
        }
        WorldGenLevel worldgenlevel = context.level();
        ResourceKey biome = worldgenlevel.getBiome(blockpos = context.origin()).getKey();
        if (biome == Biomes.DEEP_DARK) {
            return false;
        }
        GeyserConfiguration geyserConfiguration = (GeyserConfiguration)context.config();
        this.setBlock((LevelWriter)worldgenlevel, blockpos, geyserConfiguration.geyserProvider.getState(RandomSource.create(), blockpos));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.north().below(), geyserConfiguration.blockProvider.getState(RandomSource.create(), blockpos.north().below()));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.south().below(), geyserConfiguration.blockProvider.getState(RandomSource.create(), blockpos.south().below()));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.east().below(), geyserConfiguration.blockProvider.getState(RandomSource.create(), blockpos.east().below()));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.west().below(), geyserConfiguration.blockProvider.getState(RandomSource.create(), blockpos.west().below()));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.below().below(), geyserConfiguration.liquidProvider.getState(RandomSource.create(), blockpos.below().below()));
        this.setBlock((LevelWriter)worldgenlevel, blockpos.below(), geyserConfiguration.liquidProvider.getState(RandomSource.create(), blockpos.below()));
        return true;
    }
}

