/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.replace;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.SpelunkersCharmConfig;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.replace.ReplaceMultiBlockSphereConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ReplaceMultiBlockBlobFeature
extends Feature<ReplaceMultiBlockSphereConfiguration> {
    public ReplaceMultiBlockBlobFeature(Codec<ReplaceMultiBlockSphereConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ReplaceMultiBlockSphereConfiguration> context) {
        if (!((Boolean)SpelunkersCharmConfig.STONE_REPLACERS.get()).booleanValue()) {
            return false;
        }
        ReplaceMultiBlockSphereConfiguration config = (ReplaceMultiBlockSphereConfiguration)context.config();
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        TagKey<Block> blockTag = config.blocksToReplace;
        BlockPos original = context.origin();
        int clampedY = Math.max(world.getMinBuildHeight() + 1, Math.min(original.getY(), world.getMaxBuildHeight() - 1));
        BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(original.getX(), clampedY, original.getZ());
        BlockPos targetPos = ReplaceMultiBlockBlobFeature.findTarget((LevelAccessor)world, origin, blockTag);
        if (targetPos == null) {
            return false;
        }
        int radiusX = config.radius().sample(random);
        int radiusY = config.radius().sample(random);
        int radiusZ = config.radius().sample(random);
        int maxRadius = Math.max(radiusX, Math.max(radiusY, radiusZ));
        boolean placedAny = false;
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)targetPos, (int)radiusX, (int)radiusY, (int)radiusZ)) {
            BlockState current;
            if (pos.distManhattan((Vec3i)targetPos) > maxRadius || !(current = world.getBlockState(pos)).is(blockTag)) continue;
            this.setBlock((LevelWriter)world, pos, config.replaceState);
            placedAny = true;
        }
        return placedAny;
    }

    @Nullable
    private static BlockPos findTarget(LevelAccessor level, BlockPos.MutableBlockPos pos, TagKey<Block> targets) {
        while (pos.getY() > level.getMinBuildHeight() + 1) {
            BlockState state = level.getBlockState((BlockPos)pos);
            if (state.is(targets)) {
                return pos.immutable();
            }
            pos.move(Direction.DOWN);
        }
        return null;
    }
}

