/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.spread_blob;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.spread_blob.ReplaceSpreadingSphereConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ReplaceSpreadingBlobsFeature
extends Feature<ReplaceSpreadingSphereConfiguration> {
    public ReplaceSpreadingBlobsFeature(Codec<ReplaceSpreadingSphereConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ReplaceSpreadingSphereConfiguration> context) {
        ReplaceSpreadingSphereConfiguration config = (ReplaceSpreadingSphereConfiguration)context.config();
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        Block targetBlock = config.targetState.getBlock();
        BlockPos origin = ReplaceSpreadingBlobsFeature.findTarget((LevelAccessor)world, context.origin().mutable().clamp(Direction.Axis.Y, world.getMinBuildHeight() + 1, world.getMaxBuildHeight() - 1), targetBlock);
        if (origin == null) {
            return false;
        }
        int radiusX = config.radius().sample(random);
        int radiusY = config.radius().sample(random);
        int radiusZ = config.radius().sample(random);
        int maxRadius = Math.max(radiusX, Math.max(radiusY, radiusZ));
        boolean placedAny = false;
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)origin, (int)radiusX, (int)radiusY, (int)radiusZ)) {
            BlockState currentState;
            if (pos.distManhattan((Vec3i)origin) > maxRadius || !(currentState = world.getBlockState(pos)).is(targetBlock)) continue;
            boolean isEdge = false;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.relative(dir);
                if (neighbor.distManhattan((Vec3i)origin) <= maxRadius && world.getBlockState(neighbor).is(targetBlock)) continue;
                isEdge = true;
                break;
            }
            BlockState toPlace = isEdge ? config.outerState : config.innerState;
            this.setBlock((LevelWriter)world, pos, toPlace);
            placedAny = true;
        }
        return placedAny;
    }

    @Nullable
    private static BlockPos findTarget(LevelAccessor level, BlockPos.MutableBlockPos pos, Block targetBlock) {
        while (pos.getY() > level.getMinBuildHeight() + 1) {
            if (level.getBlockState((BlockPos)pos).is(targetBlock)) {
                return pos.immutable();
            }
            pos.move(Direction.DOWN);
        }
        return null;
    }
}

