/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.aether;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.player.util.IAetherAbility;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.entities.passive.mountable.EntityParachute;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.tools.ItemValkyrieTool;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketCapeChanged;
import com.gildedgames.the_aether.network.packets.PacketPerkChanged;
import com.gildedgames.the_aether.network.packets.PacketPortalItem;
import com.gildedgames.the_aether.network.packets.PacketSendPoisonTime;
import com.gildedgames.the_aether.network.packets.PacketSendSeenDialogue;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.player.perks.util.DonatorMoaSkin;
import com.gildedgames.the_aether.player.perks.util.EnumAetherPerkType;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import com.gildedgames.the_aether.world.TeleporterAether;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Teleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerAether.class})
public class MixinPlayerAether {
    @Shadow
    private EntityPlayer player;
    @Shadow
    private IAetherBoss focusedBoss;
    @Shadow
    private final ArrayList<IAetherAbility> abilities = new ArrayList();
    @Shadow
    public final ArrayList<Entity> clouds = new ArrayList(2);
    @Shadow
    public int shardCount;
    @Shadow
    public DonatorMoaSkin donatorMoaSkin = new DonatorMoaSkin();
    @Shadow
    public boolean shouldRenderHalo = true;
    @Shadow
    public boolean shouldRenderGlow = false;
    @Shadow
    public boolean shouldRenderCape = true;
    @Shadow
    public boolean seenSpiritDialog = false;
    @Shadow
    private boolean isJumping;
    @Shadow
    private boolean isMountSneaking;
    @Shadow
    private boolean inPortal;
    @Shadow
    private int portalCounter;
    @Shadow
    public int teleportDirection;
    @Shadow
    private String hammerName = StatCollector.func_74838_a((String)"item.notch_hammer.name");
    @Shadow
    private int cooldown;
    @Shadow
    private int cooldownMax;
    @Shadow
    public float wingSinage;
    @Shadow
    public float timeInPortal;
    @Shadow
    public float prevTimeInPortal;
    @Shadow
    public Entity riddenEntity;
    @Shadow
    private ChunkCoordinates bedLocation;
    @Shadow
    public boolean isPoisoned = false;
    @Shadow
    public boolean isCured = false;
    @Shadow
    public boolean shouldGetPortal = true;
    @Shadow
    public int poisonTime = 0;
    @Shadow
    public int cureTime = 0;
    @Shadow
    private UUID uuid = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
    @Shadow
    private AttributeModifier healthModifier;

    @Unique
    private boolean getIsJumping() {
        return this.isJumping;
    }

    @Unique
    private void setIsJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Inject(method={"onUpdate"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onUpdate(CallbackInfo ci) {
        if (OptimizationsandTweaksConfig.enableMixinPlayerAether) {
            int i;
            if (!this.player.field_70170_p.field_72995_K) {
                AetherNetwork.sendToAll((IMessage)new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Halo, this.shouldRenderHalo));
                AetherNetwork.sendToAll((IMessage)new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Glow, this.shouldRenderGlow));
                AetherNetwork.sendToAll((IMessage)new PacketCapeChanged(this.getEntity().func_145782_y(), this.shouldRenderCape));
                AetherNetwork.sendToAll((IMessage)new PacketSendPoisonTime(this.getEntity(), this.poisonTime));
                AetherNetwork.sendToAll((IMessage)new PacketSendSeenDialogue(this.getEntity(), this.seenSpiritDialog));
                AetherNetwork.sendToAll((IMessage)new PacketPortalItem(this.getEntity(), this.shouldGetPortal));
            }
            if (this.isPoisoned) {
                this.poisonTime = Math.max(0, this.poisonTime - 1);
                boolean bl = this.isPoisoned = this.poisonTime > 0;
            }
            if (this.isCured) {
                this.cureTime = Math.max(0, this.cureTime - 1);
                this.isCured = this.cureTime > 0;
            }
            for (i = 0; i < this.getAbilities().size(); ++i) {
                IAetherAbility ability = this.getAbilities().get(i);
                if (!ability.shouldExecute()) continue;
                ability.onUpdate();
            }
            for (i = 0; i < this.clouds.size(); ++i) {
                Entity entity = this.clouds.get(i);
                if (!entity.field_70128_L) continue;
                this.clouds.remove(i);
            }
            this.cooldown = Math.max(0, this.cooldown - 2);
            if (this.isInsideBlock(BlocksAether.aercloud)) {
                this.getEntity().field_70143_R = 0.0f;
            }
            if (this.getEntity().field_70181_x < -2.0) {
                this.activateParachute();
            }
            this.wingSinage += this.getEntity().field_70122_E ? 0.15f : 0.75f;
            this.wingSinage %= 6.283186f;
            boolean hasJumped = this.getIsJumping();
            this.setIsJumping(hasJumped);
            this.getEntity().field_70170_p.field_72984_F.func_76320_a("portal");
            if (this.getEntity().field_71093_bK == AetherConfig.getAetherDimensionID() && this.getEntity().field_70163_u < -2.0) {
                this.teleportPlayer(false);
                if (this.riddenEntity != null) {
                    this.getEntity().func_70078_a(this.riddenEntity);
                    this.riddenEntity = null;
                }
            }
            if (this.inPortal) {
                if (this.getEntity().field_71088_bW <= 0) {
                    int limit = this.getEntity().func_82145_z();
                    if (this.getEntity().field_70154_o == null) {
                        if (this.portalCounter >= limit) {
                            this.portalCounter = 0;
                            this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
                            if (!this.getEntity().field_70170_p.field_72995_K) {
                                this.teleportPlayer(true);
                                this.getEntity().func_71029_a((StatBase)AchievementsAether.enter_aether);
                            }
                        } else {
                            ++this.portalCounter;
                        }
                    }
                } else {
                    this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
                }
                if (this.getEntity().field_70170_p.func_147439_a((int)this.getEntity().field_70165_t, (int)this.getEntity().field_70163_u - 1, (int)this.getEntity().field_70161_v) != Blocks.field_150350_a) {
                    AxisAlignedBB playerBounding = this.getEntity().field_70121_D;
                    int var10001 = (int)playerBounding.field_72340_a;
                    int var10002 = (int)playerBounding.field_72338_b;
                    if (this.getEntity().field_70170_p.func_147439_a(var10001, var10002, (int)playerBounding.field_72339_c) != BlocksAether.aether_portal && this.getEntity().field_70170_p.func_147439_a(var10001 = (int)playerBounding.field_72340_a, var10002 = (int)playerBounding.field_72338_b, (int)playerBounding.field_72339_c) != BlocksAether.aether_portal) {
                        this.inPortal = false;
                    }
                }
            } else {
                if (this.portalCounter > 0) {
                    this.portalCounter -= 4;
                }
                if (this.portalCounter < 0) {
                    this.portalCounter = 0;
                }
            }
            this.getEntity().field_70170_p.field_72984_F.func_76319_b();
            if (!this.getEntity().field_70170_p.field_72995_K) {
                double distance;
                ItemStack stack = this.getEntity().func_71045_bC();
                double d = distance = this.getEntity().field_71075_bZ.field_75098_d ? 5.0 : 4.5;
                if (stack != null && stack.func_77973_b() instanceof ItemValkyrieTool) {
                    distance = 8.0;
                }
                ((EntityPlayerMP)this.getEntity()).field_71134_c.setBlockReachDistance(distance);
            } else {
                this.prevTimeInPortal = this.timeInPortal;
                if (this.isInsideBlock(BlocksAether.aether_portal)) {
                    this.timeInPortal += 0.0125f;
                    if (this.timeInPortal >= 1.0f) {
                        this.timeInPortal = 1.0f;
                    }
                } else if (this.getEntity().func_70644_a(Potion.field_76431_k) && this.getEntity().func_70660_b(Potion.field_76431_k).func_76459_b() > 60) {
                    this.timeInPortal += 0.006666667f;
                    if (this.timeInPortal > 1.0f) {
                        this.timeInPortal = 1.0f;
                    }
                } else {
                    if (this.timeInPortal > 0.0f) {
                        this.timeInPortal -= 0.05f;
                    }
                    if (this.timeInPortal < 0.0f) {
                        this.timeInPortal = 0.0f;
                    }
                }
            }
            if (!this.player.field_70170_p.field_72995_K && this.bedLocation != null && this.player.field_71093_bK == AetherConfig.getAetherDimensionID() && this.player.field_70170_p.func_147439_a(this.bedLocation.field_71574_a, this.bedLocation.field_71572_b, this.bedLocation.field_71573_c) != BlocksAether.skyroot_bed) {
                this.setBedLocation(null);
            }
        }
        ci.cancel();
    }

    @Unique
    public EntityPlayer getEntity() {
        return this.player;
    }

    @Unique
    public ArrayList<IAetherAbility> getAbilities() {
        return this.abilities;
    }

    @Unique
    public boolean isInsideBlock(Block block) {
        AxisAlignedBB boundingBox = this.getEntity().field_70121_D;
        int i = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int j = MathHelper.func_76128_c((double)(boundingBox.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int l = MathHelper.func_76128_c((double)(boundingBox.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(boundingBox.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (this.getEntity().field_70170_p.func_147439_a(k1, l1, i2) != block) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Unique
    private void activateParachute() {
        if (!this.player.field_71075_bZ.field_75098_d) {
            EntityParachute parachute = null;
            ItemStack itemstack = null;
            for (int i = 0; i < this.getEntity().field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.getEntity().field_71071_by.func_70301_a(i);
                if (stackInSlot != null && stackInSlot.func_77973_b() == ItemsAether.cloud_parachute) {
                    itemstack = stackInSlot;
                    break;
                }
                if (stackInSlot == null || stackInSlot.func_77973_b() != ItemsAether.golden_parachute) continue;
                itemstack = stackInSlot;
                break;
            }
            if (itemstack != null) {
                if (itemstack.func_77973_b() == ItemsAether.cloud_parachute) {
                    parachute = new EntityParachute(this.getEntity().field_70170_p, this.getEntity(), false);
                    parachute.func_70107_b(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v);
                    this.getEntity().field_70170_p.func_72838_d((Entity)parachute);
                    this.getEntity().field_71071_by.func_146026_a(itemstack.func_77973_b());
                } else if (itemstack.func_77973_b() == ItemsAether.golden_parachute) {
                    itemstack.func_77972_a(1, (EntityLivingBase)this.getEntity());
                    parachute = new EntityParachute(this.getEntity().field_70170_p, this.getEntity(), true);
                    parachute.func_70107_b(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v);
                    this.getEntity().field_70170_p.func_72838_d((Entity)parachute);
                }
            }
        }
    }

    @Unique
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Unique
    private void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.getEntity() instanceof EntityPlayerMP) {
            int previousDimension = this.getEntity().field_71093_bK;
            int transferDimension = previousDimension == AetherConfig.getAetherDimensionID() ? AetherConfig.getTravelDimensionID() : AetherConfig.getAetherDimensionID();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            TeleporterAether teleporter = new TeleporterAether(shouldSpawnPortal, server.func_71218_a(transferDimension));
            if (this.getEntity().field_70154_o != null) {
                this.getEntity().field_70154_o.func_70078_a(null);
            }
            if (this.getEntity().field_70153_n != null) {
                this.getEntity().field_70153_n.func_70078_a(null);
            }
            if (server != null && server.func_71203_ab() != null) {
                server.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)this.getEntity(), transferDimension, (Teleporter)teleporter);
            }
        }
    }

    @Unique
    public void setBedLocation(ChunkCoordinates bedLocation) {
        this.bedLocation = bedLocation;
    }
}

