/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.EntityList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRegistry.class})
public class MixinEntityRegistry {
    @Unique
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger(0);

    @Redirect(method={"doModEntityRegistration"}, at=@At(value="INVOKE", target="Lcpw/mods/fml/common/FMLLog;fine(Ljava/lang/String;[Ljava/lang/Object;)V"), remap=false)
    private static void suppressSkipLog(String message, Object[] params) {
    }

    @Inject(method={"registerGlobalEntityID(Ljava/lang/Class;Ljava/lang/String;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void interceptEntityRegistration(Class<?> entityClass, String entityName, int id, CallbackInfo ci) {
        String finalName = MixinEntityRegistry.resolveEntityNameConflict(entityName);
        int finalId = MixinEntityRegistry.resolveEntityIdConflict(id);
        EntityList.func_75618_a(entityClass, (String)finalName, (int)finalId);
        ci.cancel();
    }

    @Inject(method={"registerGlobalEntityID(Ljava/lang/Class;Ljava/lang/String;III)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void interceptEntityRegistrationEgg(Class<?> entityClass, String entityName, int id, int eggPrimary, int eggSecondary, CallbackInfo ci) {
        String finalName = MixinEntityRegistry.resolveEntityNameConflict(entityName);
        int finalId = MixinEntityRegistry.resolveEntityIdConflict(id);
        EntityList.func_75614_a(entityClass, (String)finalName, (int)finalId, (int)eggPrimary, (int)eggSecondary);
        ci.cancel();
    }

    @Unique
    private static String resolveEntityNameConflict(String entityName) {
        String finalName = entityName;
        if (EntityList.field_75625_b.containsKey(finalName)) {
            finalName = entityName + "_" + ENTITY_COUNTER.incrementAndGet();
            LanguageRegistry.instance().addStringLocalization("entity." + finalName + ".name", "en_US", entityName);
        }
        return finalName;
    }

    @Unique
    private static int resolveEntityIdConflict(int id) {
        int finalId = id;
        if (EntityList.field_75623_d.containsKey(finalId)) {
            EntityRegistry.instance();
            finalId = EntityRegistry.findGlobalUniqueEntityId();
        }
        return finalId;
    }
}

