/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Explosion.class})
public abstract class MixinExplosion {
    @Shadow
    public double field_77284_b;
    @Shadow
    public double field_77285_c;
    @Shadow
    public double field_77282_d;
    @Shadow
    public float field_77280_f;
    @Unique
    private final Map<Integer, Float> blockDensityCache = new HashMap<Integer, Float>();
    @Unique
    private int densityCallCount = 0;

    @Redirect(method={"doExplosionA"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockDensity(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/AxisAlignedBB;)F"))
    private float optimizeBlockDensity(World world, Vec3 vec3, AxisAlignedBB aabb) {
        ++this.densityCallCount;
        int hash = (int)(aabb.field_72340_a * 7.3856093E7) ^ (int)(aabb.field_72338_b * 1.9349663E7) ^ (int)(aabb.field_72339_c * 8.3492791E7);
        Float cached = this.blockDensityCache.get(hash);
        if (cached != null) {
            return cached.floatValue();
        }
        float density = world.func_72842_a(vec3, aabb);
        this.blockDensityCache.put(hash, Float.valueOf(density));
        return density;
    }

    @Redirect(method={"doExplosionA"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntitiesWithinAABBExcludingEntity(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;", ordinal=0))
    private List resetDensityCache(World world, Entity entity, AxisAlignedBB aabb) {
        this.blockDensityCache.clear();
        this.densityCallCount = 0;
        return world.func_72839_b(entity, aabb);
    }
}

