/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.ic2;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.TickHandler;
import ic2.core.WorldData;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.init.MainConfig;
import ic2.core.network.NetworkManager;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import ic2.core.util.Util;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TickHandler.class})
public class MixinTickHandler {
    @Shadow
    private static final boolean debugTickCallback;
    @Unique
    private static WeakHashMap<ITickCallback, Throwable> optimizationsAndTweaks$debugTraces;
    @Shadow
    private static final Field updateEntityTick;
    @Shadow
    private static Throwable lastDebugTrace;

    @SubscribeEvent
    @Overwrite(remap=false)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (!IC2.platform.isSimulating() || world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            IC2.platform.profilerStartSection("Wind");
            WorldData.get((World)world).windSim.updateWind();
            IC2.platform.profilerEndStartSection("TickCallbacks");
            MixinTickHandler.optimizationsAndTweaks$processTickCallbacks(world);
            if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"balance/disableEnderChest")) {
                this.optimizationsAndTweaks$removeEnderChests(world);
            }
            IC2.platform.profilerEndSection();
        } else {
            IC2.platform.profilerStartSection("EnergyNet");
            EnergyNetGlobal.onTickEnd((World)world);
            IC2.platform.profilerEndStartSection("Networking");
            ((NetworkManager)IC2.network.get()).onTickEnd(world);
            IC2.platform.profilerEndSection();
        }
    }

    @Unique
    private void optimizationsAndTweaks$removeEnderChests(World world) {
        for (Object obj : world.field_147482_g) {
            TileEntity te;
            if (!(obj instanceof TileEntity) || !((te = (TileEntity)obj) instanceof TileEntityEnderChest) || te.func_145837_r() || !world.func_72899_e(te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
            world.func_147468_f(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            IC2.log.info(LogCategory.General, "Removed vanilla ender chest at %s.", new Object[]{Util.formatPosition((TileEntity)te)});
        }
    }

    @Unique
    private static void optimizationsAndTweaks$processTickCallbacks(World world) {
        WorldData worldData = WorldData.get((World)world);
        IC2.platform.profilerStartSection("SingleTickCallback");
        ITickCallback tickCallback = (ITickCallback)worldData.singleTickCallbacks.poll();
        while (tickCallback != null) {
            if (debugTickCallback) {
                lastDebugTrace = optimizationsAndTweaks$debugTraces.remove(tickCallback);
            }
            IC2.platform.profilerStartSection(tickCallback.getClass().getName());
            tickCallback.tickCallback(world);
            IC2.platform.profilerEndSection();
            tickCallback = (ITickCallback)worldData.singleTickCallbacks.poll();
        }
        IC2.platform.profilerEndStartSection("ContTickCallback");
        worldData.continuousTickCallbacksInUse = true;
        for (ITickCallback tickCallback2 : worldData.continuousTickCallbacks) {
            if (debugTickCallback) {
                lastDebugTrace = optimizationsAndTweaks$debugTraces.remove(tickCallback2);
            }
            IC2.platform.profilerStartSection(tickCallback2.getClass().getName());
            tickCallback2.tickCallback(world);
            IC2.platform.profilerEndSection();
        }
        worldData.continuousTickCallbacksInUse = false;
        if (debugTickCallback) {
            lastDebugTrace = null;
        }
        worldData.continuousTickCallbacks.addAll(worldData.continuousTickCallbacksToAdd);
        worldData.continuousTickCallbacksToAdd.clear();
        worldData.continuousTickCallbacksToRemove.forEach(worldData.continuousTickCallbacks::remove);
        worldData.continuousTickCallbacksToRemove.clear();
        IC2.platform.profilerEndSection();
    }

    static {
        boolean bl = debugTickCallback = System.getProperty("ic2.debugtickcallback") != null;
        if (debugTickCallback) {
            optimizationsAndTweaks$debugTraces = new WeakHashMap();
        }
        updateEntityTick = ReflectionUtil.getField(WorldServer.class, (String[])new String[]{"field_80004_Q", "updateEntityTick"});
    }
}

