/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.structpro;

import com.ternsip.structpro.universe.blocks.Classifier;
import com.ternsip.structpro.universe.blocks.UBlockPos;
import com.ternsip.structpro.universe.blocks.UBlockState;
import com.ternsip.structpro.universe.blocks.UBlocks;
import com.ternsip.structpro.universe.world.UWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={UWorld.class})
public class MixinUWorld {
    @Shadow
    private World world;

    @Inject(method={"decorate"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void optimizationsAndTweaks$preventCascadingDecorate(int chunkX, int chunkZ, CallbackInfo ci) {
        if (this.world == null) {
            ci.cancel();
            return;
        }
        if (!(this.isChunkLoaded(this.world, chunkX, chunkZ) && this.isChunkLoaded(this.world, chunkX + 1, chunkZ) && this.isChunkLoaded(this.world, chunkX, chunkZ + 1) && this.isChunkLoaded(this.world, chunkX + 1, chunkZ + 1))) {
            ci.cancel();
        }
    }

    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void optimizationsAndTweaks$preventCascadingGetBlockState(UBlockPos pos, CallbackInfoReturnable<UBlockState> cir) {
        if (this.world == null) {
            cir.setReturnValue((Object)UBlocks.AIR.getState());
            return;
        }
        if (!this.isChunkLoaded(this.world, pos.getX() >> 4, pos.getZ() >> 4)) {
            cir.setReturnValue((Object)UBlocks.AIR.getState());
        }
    }

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void optimizationsAndTweaks$preventCascadingGetHeight(Classifier classifier, int x, int z, CallbackInfoReturnable<Integer> cir) {
        if (this.world == null) {
            cir.setReturnValue((Object)64);
            return;
        }
        if (!this.isChunkLoaded(this.world, x >> 4, z >> 4)) {
            String dimName = ((UWorld)this).getDimensionName();
            int safeHeight = 64;
            if (dimName.equalsIgnoreCase("Nether")) {
                safeHeight = 32;
            } else if (dimName.equalsIgnoreCase("End")) {
                safeHeight = 60;
            }
            cir.setReturnValue((Object)safeHeight);
        }
    }

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void optimizationsAndTweaks$preventCascadingSetBlockState(UBlockPos pos, UBlockState state, CallbackInfo ci) {
        if (this.world == null) {
            ci.cancel();
            return;
        }
        if (!this.isChunkLoaded(this.world, pos.getX() >> 4, pos.getZ() >> 4)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isChunkLoaded(World world, int chunkX, int chunkZ) {
        if (!world.func_72863_F().func_73149_a(chunkX, chunkZ)) {
            return false;
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        return chunk != null && chunk.field_76636_d;
    }

    @Inject(method={"getStorage"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void optimizationsAndTweaks$safeGetStorage(Chunk chunk, int y, CallbackInfoReturnable<Object> cir) {
        if (chunk == null || !chunk.field_76636_d) {
            cir.setReturnValue(null);
        }
        ExtendedBlockStorage[] storage = chunk.func_76587_i();
        if (y < 0 || y >= 256) {
            cir.setReturnValue(null);
            return;
        }
        int i = y >> 4;
        if (storage[i] == null) {
            cir.setReturnValue(null);
        }
    }
}

