/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.traincraft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import train.common.api.crafting.ITierCraftingManager;
import train.common.api.crafting.ITierRecipe;
import train.common.core.managers.TierRecipe;
import train.common.core.managers.TierRecipeManager;

@Mixin(value={TierRecipeManager.class})
public class MixinTierRecipeManager
implements ITierCraftingManager {
    @Shadow
    private final List<ITierRecipe> recipeList = new ArrayList<ITierRecipe>();
    @Shadow
    private static TierRecipeManager instance = new TierRecipeManager();

    @Shadow
    public static ITierCraftingManager getInstance() {
        return instance;
    }

    @Overwrite(remap=false)
    public void addRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        tier = Math.max(1, Math.min(3, tier));
        outputSize = Math.max(1, Math.min(64, outputSize));
        this.addRecipeFinal(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize);
    }

    @Overwrite(remap=false)
    public void addRecipeFinal(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        this.recipeList.add((ITierRecipe)new TierRecipe(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize));
    }

    @Overwrite(remap=false)
    public ITierRecipe getTierRecipe(int tier, ItemStack output) {
        if (output == null) {
            return null;
        }
        for (ITierRecipe recipe : this.recipeList) {
            if (Item.func_150891_b((Item)recipe.getOutput().func_77973_b()) != Item.func_150891_b((Item)output.func_77973_b()) || recipe.getTier() != tier) continue;
            return recipe;
        }
        return null;
    }

    @Overwrite(remap=false)
    public List<ITierRecipe> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Overwrite(remap=false)
    public List<ITierRecipe> getTierRecipeList(int tier) {
        ArrayList<ITierRecipe> tierRecipeList = new ArrayList<ITierRecipe>();
        for (ITierRecipe recipe : this.recipeList) {
            if (recipe.getTier() != tier) continue;
            tierRecipeList.add(recipe);
        }
        return Collections.unmodifiableList(tierRecipeList);
    }
}

