/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utilsformods.thaumcraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class ThaumcraftWorldGenerator {
    private static final int SEARCH_RADIUS = 5;

    public static int countBlocksAroundPlayer(World world, int cx, int cy, int cz, Material material) {
        int radius = 5;
        int count = 0;
        int minX = Math.max(cx - radius, cx >> 4 << 4);
        int maxX = Math.min(cx + radius, (cx >> 4 << 4) + 15);
        int minZ = Math.max(cz - radius, cz >> 4 << 4);
        int maxZ = Math.min(cz + radius, (cz >> 4 << 4) + 15);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int maxY = world.func_72976_f(x, z);
                for (int y = 0; y < maxY; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block.func_149688_o() != material) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static int optimizationsAndTweaks$countFoliageAroundPlayer(World world, int x, int y, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        if (!chunk.field_76636_d) {
            return 0;
        }
        int count = 0;
        int radius = 5;
        int minX = Math.max(x - radius, chunkX << 4);
        int maxX = Math.min(x + radius, (chunkX << 4) + 15);
        int minZ = Math.max(z - radius, chunkZ << 4);
        int maxZ = Math.min(z + radius, (chunkZ << 4) + 15);
        for (int xOffset = minX; xOffset <= maxX; ++xOffset) {
            for (int zOffset = minZ; zOffset <= maxZ; ++zOffset) {
                int maxY = world.func_72976_f(xOffset, zOffset);
                for (int yOffset = 0; yOffset < maxY; ++yOffset) {
                    Block block = world.func_147439_a(xOffset, yOffset, zOffset);
                    if (block == null || !block.isLeaves((IBlockAccess)world, xOffset, yOffset, zOffset)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static void applyThresholds(World world, int x, int y, int z, Random random, int value, NodeType type, NodeModifier modifier) {
        int a;
        int water = ThaumcraftWorldGenerator.countBlocksAroundPlayer(world, x, y, z, Material.field_151586_h);
        int lava = ThaumcraftWorldGenerator.countBlocksAroundPlayer(world, x, y, z, Material.field_151587_i);
        int stone = ThaumcraftWorldGenerator.countBlocksAroundPlayer(world, x, y, z, Blocks.field_150348_b.func_149688_o());
        int foliage = ThaumcraftWorldGenerator.optimizationsAndTweaks$countFoliageAroundPlayer(world, x, y, z);
        int THRESHOLD_WATER = 100;
        int THRESHOLD_LAVA = 100;
        int THRESHOLD_STONE = 500;
        int THRESHOLD_FOLIAGE = 100;
        AspectList al = new AspectList();
        if (water > 100) {
            al.merge(Aspect.WATER, 1);
        }
        if (lava > 100) {
            al.merge(Aspect.FIRE, 1);
            al.merge(Aspect.EARTH, 1);
        }
        if (stone > 500) {
            al.merge(Aspect.EARTH, 1);
        }
        if (foliage > 100) {
            al.merge(Aspect.PLANT, 1);
        }
        int totalAmount = al.size();
        int[] spread = new int[totalAmount];
        float totalSpread = 0.0f;
        for (a = 0; a < totalAmount; ++a) {
            int aspectAmount = al.getAmount(al.getAspectsSorted()[a]);
            spread[a] = aspectAmount == 2 ? 50 + random.nextInt(25) : 25 + random.nextInt(50);
            totalSpread += (float)spread[a];
        }
        for (a = 0; a < totalAmount; ++a) {
            float spreadValue = (float)spread[a] / totalSpread * (float)value;
            al.merge(al.getAspectsSorted()[a], (int)spreadValue);
        }
        thaumcraft.common.lib.world.ThaumcraftWorldGenerator.createNodeAt((World)world, (int)x, (int)y, (int)z, (NodeType)type, (NodeModifier)modifier, (AspectList)al);
    }
}

