/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.animalsplus;

import clickme.animals.entity.water.EntitySwimming;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.util.FastMath;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntitySwimming.class})
public abstract class MixinEntitySwimming
extends EntityLiving
implements IAnimals {
    @Shadow
    private double swimTargetX;
    @Shadow
    private double swimTargetY;
    @Shadow
    private double swimTargetZ;
    @Shadow
    private Entity targetEntity;
    @Shadow
    private boolean isAttacking;
    @Shadow
    protected float swimRadius = 4.0f;
    @Shadow
    protected float swimRadiusHeight = 4.0f;
    @Shadow
    protected boolean isAgressive = false;
    @Shadow
    protected int attackInterval = 50;
    @Shadow
    protected float attackSpeed = 1.2f;
    @Shadow
    protected float swimSpeed = 0.5f;
    @Shadow
    protected boolean jumpOnLand = true;

    public MixinEntitySwimming(World p_i1595_1_) {
        super(p_i1595_1_);
    }

    @Overwrite(remap=false)
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70090_H()) {
            double dx = this.swimTargetX - this.field_70165_t;
            double dy = this.swimTargetY - this.field_70163_u;
            double dz = this.swimTargetZ - this.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (dist < 1.0 || dist > 1000.0) {
                this.swimTargetX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.swimTargetY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadiusHeight);
                this.swimTargetZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.isAttacking = false;
            }
            if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.swimTargetX), MathHelper.func_76128_c((double)(this.swimTargetY + (double)this.field_70131_O)), MathHelper.func_76128_c((double)this.swimTargetZ)).func_149688_o() == Material.field_151586_h) {
                this.field_70159_w += dx / dist * 0.05 * (double)this.swimSpeed;
                this.field_70181_x += dy / dist * 0.1 * (double)this.swimSpeed;
                this.field_70179_y += dz / dist * 0.05 * (double)this.swimSpeed;
            } else {
                this.swimTargetX = this.field_70165_t;
                this.swimTargetY = this.field_70163_u + 0.1;
                this.swimTargetZ = this.field_70161_v;
            }
            if (this.isAttacking) {
                this.field_70159_w *= (double)this.attackSpeed;
                this.field_70181_x *= (double)this.attackSpeed;
                this.field_70179_y *= (double)this.attackSpeed;
            }
            if (this.isAgressive && this.field_70146_Z.nextInt(this.attackInterval) == 0) {
                this.targetEntity = this.findPlayerToAttack();
                if (this.targetEntity != null && this.targetEntity.func_70090_H()) {
                    this.swimTargetX = this.targetEntity.field_70165_t;
                    this.swimTargetY = this.targetEntity.field_70163_u;
                    this.swimTargetZ = this.targetEntity.field_70161_v;
                    this.isAttacking = true;
                }
            }
            this.field_70761_aq += (-((float)FastMath.atan2(this.field_70181_x, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.5f;
            this.field_70177_z = this.field_70761_aq;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70125_A += ((float)FastMath.atan2(this.field_70181_x, f) * 180.0f / (float)Math.PI - this.field_70125_A) * 0.5f;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x -= 0.08;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y = 0.0;
            if (this.jumpOnLand && this.field_70122_E && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = 0.3f;
                this.field_70159_w = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
                this.field_70179_y = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
            }
        }
    }

    @Shadow
    protected Entity findPlayerToAttack() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return player != null && this.func_70685_l((Entity)player) ? player : null;
    }
}

