/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Object2ObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LaunchClassLoader.class})
public abstract class MixinLaunchClassLoader
extends URLClassLoader {
    @Shadow
    public static final int BUFFER_SIZE = 4096;
    @Unique
    private ArrayList<URL> optimizationsAndTweaks$sources;
    @Shadow
    private ClassLoader parent = this.getClass().getClassLoader();
    @Shadow
    private List<IClassTransformer> transformers = new ArrayList<IClassTransformer>(2);
    @Unique
    private Object2ObjectHashMap<String, Class<?>> optimizationsAndTweaks$cachedClasses = new Object2ObjectHashMap();
    @Shadow
    private Set<String> invalidClasses = new HashSet<String>(1000);
    @Shadow
    private Set<String> classLoaderExceptions = new HashSet<String>();
    @Shadow
    private Set<String> transformerExceptions = new HashSet<String>();
    @Unique
    private Object2ObjectHashMap<Package, Manifest> optimizationsAndTweaks$packageManifests = new Object2ObjectHashMap();
    @Unique
    private Object2ObjectHashMap<String, byte[]> optimizationsAndTweaks$resourceCache = new Object2ObjectHashMap();
    @Unique
    private Set<String> optimizationsAndTweaks$negativeResourceCache = Collections.newSetFromMap(new Object2ObjectHashMap());
    @Shadow
    private IClassNameTransformer renameTransformer;
    @Shadow
    private static final Manifest EMPTY = new Manifest();
    @Shadow
    private final ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    @Shadow
    private static final String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    @Shadow
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false"));
    @Shadow
    private static final boolean DEBUG_FINER = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingFiner", "false"));
    @Shadow
    private static final boolean DEBUG_SAVE = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "false"));
    @Shadow
    private static File tempFolder = null;

    public MixinLaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.optimizationsAndTweaks$sources = new ArrayList<URL>(Arrays.asList(sources));
        this.addClassLoaderExclusion("java.");
        this.addClassLoaderExclusion("sun.");
        this.addClassLoaderExclusion("org.lwjgl.");
        this.addClassLoaderExclusion("org.apache.logging.");
        this.addClassLoaderExclusion("net.minecraft.launchwrapper.");
        this.addTransformerExclusion("javax.");
        this.addTransformerExclusion("argo.");
        this.addTransformerExclusion("org.objectweb.asm.");
        this.addTransformerExclusion("com.google.common.");
        this.addTransformerExclusion("org.bouncycastle.");
        this.addTransformerExclusion("net.minecraft.launchwrapper.injector.");
        if (DEBUG_SAVE) {
            int x = 1;
            tempFolder = new File(Launch.minecraftHome, "CLASSLOADER_TEMP");
            while (tempFolder.exists() && x <= 10) {
                tempFolder = new File(Launch.minecraftHome, "CLASSLOADER_TEMP" + x++);
            }
            if (tempFolder.exists()) {
                LogWrapper.info((String)"DEBUG_SAVE enabled, but 10 temp directories already exist, clean them and try again.", (Object[])new Object[0]);
                tempFolder = null;
            } else {
                LogWrapper.info((String)"DEBUG_SAVE Enabled, saving all classes to \"%s\"", (Object[])new Object[]{tempFolder.getAbsolutePath().replace('\\', '/')});
                tempFolder.mkdirs();
            }
        }
    }

    @Overwrite(remap=false)
    public void registerTransformer(String transformerClassName) {
        try {
            IClassTransformer transformer = (IClassTransformer)this.loadClass(transformerClassName).newInstance();
            this.transformers.add(transformer);
            if (transformer instanceof IClassNameTransformer && this.renameTransformer == null) {
                this.renameTransformer = (IClassNameTransformer)transformer;
            }
        }
        catch (Exception e) {
            LogWrapper.log((Level)Level.ERROR, (Throwable)e, (String)"A critical problem occurred registering the ASM transformer class %s", (Object[])new Object[]{transformerClassName});
        }
    }

    @Override
    @Overwrite(remap=false)
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        for (String exception : this.classLoaderExceptions) {
            if (!name.startsWith(exception)) continue;
            return this.parent.loadClass(name);
        }
        if (this.optimizationsAndTweaks$cachedClasses.containsKey(name)) {
            return this.optimizationsAndTweaks$cachedClasses.get(name);
        }
        try {
            Class<?> clazz = super.findClass(name);
            this.optimizationsAndTweaks$cachedClasses.put(name, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            this.invalidClasses.add(name);
            throw e;
        }
    }

    @Overwrite(remap=false)
    private void saveTransformedClass(byte[] data, String transformedName) {
        if (tempFolder == null) {
            return;
        }
        File outFile = new File(tempFolder, transformedName.replace('.', File.separatorChar) + ".class");
        File outDir = outFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            LogWrapper.fine((String)"Saving transformed class \"%s\" to \"%s\"", (Object[])new Object[]{transformedName, outFile.getAbsolutePath().replace('\\', '/')});
            Path outPath = outFile.toPath();
            Files.write(outPath, data, new OpenOption[0]);
        }
        catch (IOException ex) {
            LogWrapper.log((Level)Level.WARN, (Throwable)ex, (String)"Could not save transformed class \"%s\"", (Object[])new Object[]{transformedName});
        }
    }

    @Overwrite(remap=false)
    private String untransformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.unmapClassName(name);
        }
        return name;
    }

    @Overwrite(remap=false)
    private String transformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.remapClassName(name);
        }
        return name;
    }

    @Overwrite(remap=false)
    private boolean isSealed(String path, Manifest manifest) {
        Attributes attributes = manifest.getAttributes(path);
        String sealed = null;
        if (attributes != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attributes = manifest.getMainAttributes()) != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Overwrite(remap=false)
    private URLConnection findCodeSourceConnectionFor(String name) {
        URL resource = this.findResource(name);
        if (resource != null) {
            try {
                return resource.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Overwrite(remap=false)
    private byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        if (DEBUG_FINER) {
            LogWrapper.finest((String)"Beginning transform of {%s (%s)} Start Length: %d", (Object[])new Object[]{name, transformedName, basicClass == null ? 0 : basicClass.length});
            for (IClassTransformer transformer : this.transformers) {
                String transName = transformer.getClass().getName();
                LogWrapper.finest((String)"Before Transformer {%s (%s)} %s: %d", (Object[])new Object[]{name, transformedName, transName, basicClass == null ? 0 : basicClass.length});
                basicClass = transformer.transform(name, transformedName, basicClass);
                LogWrapper.finest((String)"After  Transformer {%s (%s)} %s: %d", (Object[])new Object[]{name, transformedName, transName, basicClass == null ? 0 : basicClass.length});
            }
            LogWrapper.finest((String)"Ending transform of {%s (%s)} Start Length: %d", (Object[])new Object[]{name, transformedName, basicClass == null ? 0 : basicClass.length});
        } else {
            for (IClassTransformer transformer : this.transformers) {
                basicClass = transformer.transform(name, transformedName, basicClass);
            }
        }
        return basicClass;
    }

    @Override
    @Overwrite(remap=false)
    public void addURL(URL url) {
        super.addURL(url);
        this.optimizationsAndTweaks$sources.add(url);
    }

    @Overwrite(remap=false)
    public List<URL> getSources() {
        return this.optimizationsAndTweaks$sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    private byte[] readFully(InputStream stream) {
        try {
            int read;
            byte[] buffer = this.getOrCreateBuffer();
            int totalLength = 0;
            while ((read = stream.read(buffer, totalLength, buffer.length - totalLength)) != -1) {
                if ((totalLength += read) < buffer.length - 1) continue;
                byte[] newBuffer = new byte[buffer.length + 4096];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            byte[] result = new byte[totalLength];
            System.arraycopy(buffer, 0, result, 0, totalLength);
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable t) {
            LogWrapper.log((Level)Level.WARN, (Throwable)t, (String)"Problem loading class", (Object[])new Object[0]);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            this.loadBuffer.remove();
        }
    }

    @Overwrite(remap=false)
    private byte[] getOrCreateBuffer() {
        byte[] buffer = this.loadBuffer.get();
        if (buffer == null) {
            this.loadBuffer.set(new byte[4096]);
            buffer = this.loadBuffer.get();
        }
        return buffer;
    }

    @Overwrite(remap=false)
    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    @Overwrite(remap=false)
    public void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    @Overwrite(remap=false)
    public void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public byte[] getClassBytes(String name) throws IOException {
        URL classResource;
        InputStream classStream;
        block8: {
            byte[] byArray;
            if (this.optimizationsAndTweaks$resourceCache.containsKey(name)) {
                return this.optimizationsAndTweaks$resourceCache.get(name);
            }
            if (name.indexOf(46) == -1) {
                for (String string : RESERVED_NAMES) {
                    byte[] data;
                    if (!name.toUpperCase(Locale.ENGLISH).startsWith(string) || (data = this.getClassBytes("_" + name)).length <= 0) continue;
                    this.optimizationsAndTweaks$resourceCache.put(name, data);
                    return data;
                }
            }
            classStream = null;
            try {
                String resourcePath = name.replace('.', '/').concat(".class");
                classResource = this.findResource(resourcePath);
                if (classResource != null) break block8;
                if (DEBUG) {
                    LogWrapper.finest((String)"Failed to find class resource %s", (Object[])new Object[]{resourcePath});
                }
                byArray = new byte[]{};
            }
            catch (Throwable throwable) {
                MixinLaunchClassLoader.closeSilently(classStream);
                throw throwable;
            }
            MixinLaunchClassLoader.closeSilently(classStream);
            return byArray;
        }
        classStream = classResource.openStream();
        if (DEBUG) {
            LogWrapper.finest((String)"Loading class %s from resource %s", (Object[])new Object[]{name, classResource.toString()});
        }
        byte[] byArray = this.readFully(classStream);
        this.optimizationsAndTweaks$resourceCache.put(name, byArray);
        byte[] byArray2 = byArray;
        MixinLaunchClassLoader.closeSilently(classStream);
        return byArray2;
    }

    @Overwrite(remap=false)
    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Overwrite(remap=false)
    public void clearNegativeEntries(Set<String> entriesToClear) {
    }
}

