/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.etfuturumrequiem;

import ganymedes01.etfuturum.core.utils.Utils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Utils.class})
public class MixinUtils {
    @Unique
    private static final double optimizationsAndTweaks$frac_bias = Double.longBitsToDouble(4805340802404319232L);
    @Unique
    private static final double[] optimizationsAndTweaks$asine_tab = new double[257];
    @Unique
    private static final double[] optimizationsAndTweaks$cos_tab = new double[257];

    @Overwrite
    public static double atan2(double y, double x) {
        boolean isYGreaterThanX;
        boolean isNegativeX;
        boolean isNegativeY;
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        boolean bl = isNegativeY = y < 0.0;
        if (isNegativeY) {
            y = -y;
        }
        boolean bl2 = isNegativeX = x < 0.0;
        if (isNegativeX) {
            x = -x;
        }
        boolean bl3 = isYGreaterThanX = y > x;
        if (isYGreaterThanX) {
            double temp = x;
            x = y;
            y = temp;
        }
        double magnitudeSquared = x * x + y * y;
        double invMagnitude = MixinUtils.optimizationsAndTweaks$invSqrt(magnitudeSquared);
        double angle = MixinUtils.optimizationsAndTweaks$getAngle(y *= invMagnitude, x *= invMagnitude);
        if (isYGreaterThanX) {
            angle = 1.5707963267948966 - angle;
        }
        if (isNegativeX) {
            angle = Math.PI - angle;
        }
        if (isNegativeY) {
            angle = -angle;
        }
        return angle;
    }

    @Unique
    private static double optimizationsAndTweaks$getAngle(double y, double x) {
        double biasedY = optimizationsAndTweaks$frac_bias + y;
        int index = (int)Double.doubleToRawLongBits(biasedY);
        double asinValue = optimizationsAndTweaks$asine_tab[index];
        double cosValue = optimizationsAndTweaks$cos_tab[index];
        double deltaY = biasedY - optimizationsAndTweaks$frac_bias;
        double delta = y * cosValue - x * deltaY;
        double correctionTerm = (6.0 + delta * delta) * delta * 0.16666666666666666;
        return asinValue + correctionTerm;
    }

    @Unique
    private static double optimizationsAndTweaks$invSqrt(double num) {
        return 1.0 / Math.sqrt(num);
    }

    static {
        for (int j = 0; j < 257; ++j) {
            double ratio = (double)j / 256.0;
            double asinValue = Math.asin(ratio);
            MixinUtils.optimizationsAndTweaks$cos_tab[j] = Math.cos(asinValue);
            MixinUtils.optimizationsAndTweaks$asine_tab[j] = asinValue;
        }
    }
}

