/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.notenoughpets;

import astrotibs.notenoughpets.config.GeneralConfig;
import astrotibs.notenoughpets.entity.EntityOcelotNEP;
import astrotibs.notenoughpets.entity.EntityWolfNEP;
import astrotibs.notenoughpets.events.EventHandlerNEP;
import astrotibs.notenoughpets.util.LogHelper;
import astrotibs.notenoughpets.util.SkinVariations;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EventHandlerNEP.class})
public class MixinEventHandlerNEP {
    @Shadow
    public static boolean isInRange(int x, int y, int z, Village village) {
        return village.func_75577_a().func_71569_e(x, y, z) < (float)((village.func_75568_b() + 32) * (village.func_75568_b() + 32));
    }

    @Shadow
    private static Vec3 tryGetStraySpawningLocation(Village village, World world, int rangeX, int rangeY, int rangeZ) {
        int vilCenterX = village.func_75577_a().field_71574_a;
        int vilCenterY = village.func_75577_a().field_71572_b;
        int vilCenterZ = village.func_75577_a().field_71573_c;
        int vilRadius = village.func_75568_b();
        for (int k1 = 0; k1 < 10; ++k1) {
            int tryZ;
            int tryY;
            int tryX = vilCenterX + world.field_73012_v.nextInt(2 * vilRadius + 1) - vilRadius;
            if (!MixinEventHandlerNEP.isInRange(tryX, tryY = vilCenterY + world.field_73012_v.nextInt(8) - 4, tryZ = vilCenterZ + world.field_73012_v.nextInt(2 * vilRadius + 1) - vilRadius, village) || !MixinEventHandlerNEP.isValidSpawningLocation(tryX, tryY, tryZ, rangeX, rangeY, rangeZ, world)) continue;
            return Vec3.func_72443_a((double)tryX, (double)tryY, (double)tryZ);
        }
        return null;
    }

    @Shadow
    private static boolean isValidSpawningLocation(int spawnposX, int spawnposY, int spawnposZ, int xRange, int yRange, int zRange, World world) {
        if (!World.func_147466_a((IBlockAccess)world, (int)spawnposX, (int)(spawnposY - 1), (int)spawnposZ)) {
            return false;
        }
        int k1 = spawnposX - xRange / 2;
        int l1 = spawnposZ - zRange / 2;
        for (int checkX = k1; checkX < k1 + xRange; ++checkX) {
            for (int checkY = spawnposY; checkY < spawnposY + yRange; ++checkY) {
                for (int checkZ = l1; checkZ < l1 + zRange; ++checkZ) {
                    if (!world.func_147439_a(checkX, checkY, checkZ).func_149721_r()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Shadow
    private static int countEntityAroundVillage(Class entityClass, Village village, World world, int villageBuffer) {
        int vilX = village.func_75577_a().field_71574_a;
        int vilY = village.func_75577_a().field_71572_b;
        int vilZ = village.func_75577_a().field_71573_c;
        int vilR = village.func_75568_b();
        List list = world.func_72872_a(entityClass, AxisAlignedBB.func_72330_a((double)(vilX - vilR - villageBuffer), (double)(vilY - 4), (double)(vilZ - vilR - villageBuffer), (double)(vilX + vilR + villageBuffer), (double)(vilY + 4), (double)(vilZ + vilR + villageBuffer)));
        return list != null ? list.size() : 0;
    }

    @Shadow
    private static void trySpawnStray(Village village, World world) {
        Vec3 vec3;
        EntityOcelotNEP entityStray;
        float strayFraction;
        Class<EntityOcelot> strayClass;
        int spawnCap;
        float f = world.field_73012_v.nextFloat();
        float f2 = !GeneralConfig.enableNECDogs ? 1.0f : GeneralConfig.strayFractionCat;
        if (f < f2 && GeneralConfig.enableNECCats) {
            spawnCap = GeneralConfig.villageSpawnCapCat;
            strayClass = EntityOcelot.class;
            strayFraction = !GeneralConfig.enableNECDogs ? 1.0f : GeneralConfig.strayFractionCat;
            entityStray = new EntityOcelotNEP(world);
            entityStray.func_70912_b(world.field_73012_v.nextInt((GeneralConfig.enableNECCats && !GeneralConfig.revertAnimalTypes ? SkinVariations.catSkinArray.length : 4) - 1) + 1);
        } else {
            if (!GeneralConfig.enableNECDogs) {
                return;
            }
            spawnCap = GeneralConfig.villageSpawnCapDog;
            strayClass = EntityWolf.class;
            strayFraction = GeneralConfig.enableNECCats ? 1.0f - GeneralConfig.strayFractionCat : 1.0f;
            entityStray = new EntityWolfNEP(world);
            ((EntityWolfNEP)entityStray).setTameSkin(GeneralConfig.enableNECDogs && !GeneralConfig.revertAnimalTypes ? world.field_73012_v.nextInt(SkinVariations.dogSkinArray.length - 1) + 1 : 0);
        }
        if (spawnCap > 0 && MixinEventHandlerNEP.countEntityAroundVillage(strayClass, village, world, 32) < Math.min(Math.round(GeneralConfig.strayCapFromVillageRadius ? (float)(village.func_75568_b() * village.func_75568_b() / 500) : (float)Math.min(village.func_75562_e(), village.func_75567_c() / 4) * strayFraction), spawnCap) && (vec3 = MixinEventHandlerNEP.tryGetStraySpawningLocation(village, world, 2, 4, 2)) != null) {
            ((EntityTameable)entityStray).func_70012_b(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            ((EntityTameable)entityStray).func_70903_f(false);
            ((EntityTameable)entityStray).func_70873_a(Math.min(24000 - world.field_73012_v.nextInt(48001), 0));
            world.func_72838_d((Entity)entityStray);
        }
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void spawnStraysWithVillageTick(TickEvent.WorldTickEvent event) {
        VillageCollection vc;
        int vcTickCounter;
        if (Arrays.binarySearch(GeneralConfig.strayDimensions, event.world.field_73011_w.field_76574_g) >= 0 && (GeneralConfig.enableNECCats && !GeneralConfig.revertAnimalTypes ? GeneralConfig.villageSpawnCapCat : 0) + (GeneralConfig.enableNECDogs && !GeneralConfig.revertAnimalTypes ? GeneralConfig.villageSpawnCapDog : 0) > 0 && !event.world.field_72995_K && event.phase == TickEvent.Phase.END && (vcTickCounter = ((Integer)ReflectionHelper.getPrivateValue(VillageCollection.class, (Object)(vc = event.world.field_72982_D), (String[])new String[]{"tickCounter", "field_75553_e"})).intValue()) % 30 == 0) {
            for (Village village : vc.func_75540_b()) {
                if (GeneralConfig.debugMessages && vcTickCounter % 90 == 0) {
                    LogHelper.info((Object)("Village " + village + " cats: " + MixinEventHandlerNEP.countEntityAroundVillage(EntityOcelot.class, village, event.world, 32) + ", dogs: " + MixinEventHandlerNEP.countEntityAroundVillage(EntityWolf.class, village, event.world, 32)));
                }
                if ((GeneralConfig.enableNECCats && !GeneralConfig.revertAnimalTypes && GeneralConfig.villageSpawnCapCat > 0 ? MixinEventHandlerNEP.countEntityAroundVillage(EntityOcelotNEP.class, village, event.world, 32) : 0) + (GeneralConfig.enableNECDogs && !GeneralConfig.revertAnimalTypes && GeneralConfig.villageSpawnCapDog > 0 ? MixinEventHandlerNEP.countEntityAroundVillage(EntityWolfNEP.class, village, event.world, 32) : 0) >= Math.min(GeneralConfig.strayCapFromVillageRadius ? village.func_75568_b() * village.func_75568_b() / 500 : Math.min(village.func_75562_e(), village.func_75567_c() / 4), GeneralConfig.revertAnimalTypes ? 0 : Math.max(GeneralConfig.enableNECCats ? GeneralConfig.villageSpawnCapCat : 0, GeneralConfig.enableNECDogs ? GeneralConfig.villageSpawnCapDog : 0)) || event.world.field_73012_v.nextInt(100) >= GeneralConfig.villageSpawnRatePercent) continue;
                MixinEventHandlerNEP.trySpawnStray(village, event.world);
            }
        }
    }

    @Unique
    private static void optimizationsAndTweaks$trySpawnStray(Village village, World world) {
        Vec3 vec3;
        EntityOcelotNEP entityStray;
        float strayFraction;
        Class<EntityOcelot> strayClass;
        int spawnCap;
        float f = world.field_73012_v.nextFloat();
        float f2 = !GeneralConfig.enableNECDogs ? 1.0f : GeneralConfig.strayFractionCat;
        if (f < f2 && GeneralConfig.enableNECCats) {
            spawnCap = GeneralConfig.villageSpawnCapCat;
            strayClass = EntityOcelot.class;
            strayFraction = !GeneralConfig.enableNECDogs ? 1.0f : GeneralConfig.strayFractionCat;
            entityStray = new EntityOcelotNEP(world);
            entityStray.func_70912_b(world.field_73012_v.nextInt((GeneralConfig.enableNECCats && !GeneralConfig.revertAnimalTypes ? SkinVariations.catSkinArray.length : 4) - 1) + 1);
        } else {
            if (!GeneralConfig.enableNECDogs) {
                return;
            }
            spawnCap = GeneralConfig.villageSpawnCapDog;
            strayClass = EntityWolf.class;
            strayFraction = GeneralConfig.enableNECCats ? 1.0f - GeneralConfig.strayFractionCat : 1.0f;
            entityStray = new EntityWolfNEP(world);
            ((EntityWolfNEP)entityStray).setTameSkin(GeneralConfig.enableNECDogs && !GeneralConfig.revertAnimalTypes ? world.field_73012_v.nextInt(SkinVariations.dogSkinArray.length - 1) + 1 : 0);
        }
        if (spawnCap > 0 && MixinEventHandlerNEP.optimizationsAndTweaks$countEntityAroundVillage(strayClass, village, world, 32) < Math.min(Math.round(GeneralConfig.strayCapFromVillageRadius ? (float)(village.func_75568_b() * village.func_75568_b() / 500) : (float)Math.min(village.func_75562_e(), village.func_75567_c() / 4) * strayFraction), spawnCap) && (vec3 = MixinEventHandlerNEP.optimizationsAndTweaks$tryGetStraySpawningLocation(village, world, 2, 4, 2)) != null) {
            entityStray.func_70012_b(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            entityStray.func_70903_f(false);
            entityStray.func_70873_a(Math.min(24000 - world.field_73012_v.nextInt(48001), 0));
            world.func_72838_d((Entity)entityStray);
        }
    }

    @Unique
    private static int optimizationsAndTweaks$countEntityAroundVillage(Class entityClass, Village village, World world, int villageBuffer) {
        int vilX = village.func_75577_a().field_71574_a;
        int vilY = village.func_75577_a().field_71572_b;
        int vilZ = village.func_75577_a().field_71573_c;
        int vilR = village.func_75568_b();
        List list = world.func_72872_a(entityClass, AxisAlignedBB.func_72330_a((double)(vilX - vilR - villageBuffer), (double)(vilY - 4), (double)(vilZ - vilR - villageBuffer), (double)(vilX + vilR + villageBuffer), (double)(vilY + 4), (double)(vilZ + vilR + villageBuffer)));
        return list != null ? list.size() : 0;
    }

    @Unique
    private static Vec3 optimizationsAndTweaks$tryGetStraySpawningLocation(Village village, World world, int rangeX, int rangeY, int rangeZ) {
        int vilCenterX = village.func_75577_a().field_71574_a;
        int vilCenterY = village.func_75577_a().field_71572_b;
        int vilCenterZ = village.func_75577_a().field_71573_c;
        int vilRadius = village.func_75568_b();
        for (int k1 = 0; k1 < 10; ++k1) {
            int tryZ;
            int tryY;
            int tryX = vilCenterX + world.field_73012_v.nextInt(2 * vilRadius + 1) - vilRadius;
            if (!MixinEventHandlerNEP.optimizationsAndTweaks$isInRange(tryX, tryY = vilCenterY + world.field_73012_v.nextInt(8) - 4, tryZ = vilCenterZ + world.field_73012_v.nextInt(2 * vilRadius + 1) - vilRadius, village) || !MixinEventHandlerNEP.optimizationsAndTweaks$isValidSpawningLocation(tryX, tryY, tryZ, rangeX, rangeY, rangeZ, world)) continue;
            return Vec3.func_72443_a((double)tryX, (double)tryY, (double)tryZ);
        }
        return null;
    }

    @Unique
    private static boolean optimizationsAndTweaks$isInRange(int x, int y, int z, Village village) {
        return village.func_75577_a().func_71569_e(x, y, z) < (float)((village.func_75568_b() + 32) * (village.func_75568_b() + 32));
    }

    @Unique
    private static boolean optimizationsAndTweaks$isValidSpawningLocation(int spawnposX, int spawnposY, int spawnposZ, int xRange, int yRange, int zRange, World world) {
        if (!World.func_147466_a((IBlockAccess)world, (int)spawnposX, (int)(spawnposY - 1), (int)spawnposZ)) {
            return false;
        }
        int k1 = spawnposX - xRange / 2;
        int l1 = spawnposZ - zRange / 2;
        for (int checkX = k1; checkX < k1 + xRange; ++checkX) {
            for (int checkY = spawnposY; checkY < spawnposY + yRange; ++checkY) {
                for (int checkZ = l1; checkZ < l1 + zRange; ++checkZ) {
                    if (!world.func_147439_a(checkX, checkY, checkZ).func_149721_r()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

