/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.mixins.Classers;
import java.util.ArrayDeque;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockFluidClassic.class})
public abstract class MixinBlockFluidClassic
extends BlockFluidBase {
    @Shadow
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    @Shadow
    protected int[] flowCost = new int[4];
    @Shadow
    protected FluidStack stack;

    public MixinBlockFluidClassic(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Shadow
    protected boolean[] getOptimalFlowDirections(World world, int x, int y, int z) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock((IBlockAccess)world, x2, y2, z2)) continue;
            this.flowCost[side2] = this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2) ? 0 : this.calculateFlowCost(world, x2, y2, z2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    @Overwrite(remap=false)
    protected int calculateFlowCost(World world, int x, int y, int z, int initialRecurseDepth, int side) {
        int cost = 1000;
        ArrayDeque<Classers.FlowCostContext> stack = new ArrayDeque<Classers.FlowCostContext>();
        stack.push(new Classers.FlowCostContext(x, y, z, initialRecurseDepth, side));
        while (!stack.isEmpty()) {
            Classers.FlowCostContext context = (Classers.FlowCostContext)stack.pop();
            int x2 = context.x;
            int y2 = context.y;
            int z2 = context.z;
            int recurseDepth = context.recurseDepth;
            int adjSide = context.adjSide;
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock((IBlockAccess)world, x2, y2, z2)) continue;
            if (recurseDepth >= 4 || this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2)) {
                return recurseDepth;
            }
            for (int nextAdjSide = 0; nextAdjSide < 4; ++nextAdjSide) {
                if (nextAdjSide == 0 && adjSide == 1 || nextAdjSide == 1 && adjSide == 0 || nextAdjSide == 2 && adjSide == 3 || nextAdjSide == 3 && adjSide == 2) continue;
                int nextX = x2;
                int nextZ = z2;
                switch (nextAdjSide) {
                    case 0: {
                        --nextX;
                        break;
                    }
                    case 1: {
                        ++nextX;
                        break;
                    }
                    case 2: {
                        --nextZ;
                        break;
                    }
                    case 3: {
                        ++nextZ;
                    }
                }
                stack.push(new Classers.FlowCostContext(nextX, y2, nextZ, recurseDepth + 1, nextAdjSide));
            }
        }
        return cost;
    }

    @Shadow
    public boolean isSourceBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) == 0;
    }

    @Shadow
    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        int density = MixinBlockFluidClassic.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }
}

