/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MinecraftServer.class}, priority=1001)
public abstract class MixinMinecraftServer {
    @Unique
    private MinecraftServer optimizationsAndTweaks$minecraftServer;
    @Unique
    private static final Logger optimizationsAndTweaks$logger = LogManager.getLogger();
    @Shadow
    public static final File field_152367_a = new File("usercache.json");
    @Shadow
    private final List field_71322_p = new ArrayList();
    @Shadow
    public final Profiler field_71304_b = new Profiler();
    @Shadow
    private final NetworkSystem field_147144_o;
    @Shadow
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    @Shadow
    private final Random field_147146_q = new Random();
    @Shadow
    @SideOnly(value=Side.SERVER)
    private String field_71320_r;
    @Shadow
    private int field_71319_s = -1;
    @Shadow
    public WorldServer[] field_71305_c = new WorldServer[0];
    @Shadow
    private ServerConfigurationManager field_71318_t;
    @Shadow
    private boolean field_71317_u = true;
    @Shadow
    private boolean field_71316_v;
    @Shadow
    private int field_71315_w;
    @Shadow
    public String field_71302_d;
    @Shadow
    public int field_71303_e;
    @Shadow
    private boolean field_71325_x;
    @Shadow
    private boolean field_71324_y;
    @Shadow
    private boolean field_71323_z;
    @Shadow
    private boolean field_71284_A;
    @Shadow
    private boolean field_71285_B;
    @Shadow
    private String field_71286_C;
    @Shadow
    private int field_71280_D;
    @Shadow
    private int field_143008_E = 0;
    @Shadow
    public final long[] field_71311_j = new long[100];
    @Shadow
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    @Shadow
    private KeyPair field_71292_I;
    @Shadow
    private String field_71293_J;
    @Shadow
    private String field_71294_K;
    @Shadow
    @SideOnly(value=Side.CLIENT)
    private String field_71287_L;
    @Shadow
    private boolean field_71288_M;
    @Shadow
    private boolean field_71289_N;
    @Shadow
    private boolean field_71290_O;
    @Shadow
    private String field_147141_M = "";
    @Shadow
    private boolean field_71296_Q;
    @Shadow
    private long field_71299_R;
    @Shadow
    private String field_71298_S;
    @Shadow
    private boolean field_71295_T;
    @Shadow
    private boolean field_104057_T;
    @Shadow
    private long field_147142_T = 0L;
    @Shadow
    private final PlayerUsageSnooper field_71307_n = new PlayerUsageSnooper("server", (IPlayerUsage)this, MixinMinecraftServer.func_130071_aq());

    public MixinMinecraftServer() {
        this.field_147144_o = new NetworkSystem(this.optimizationsAndTweaks$minecraftServer);
    }

    @Overwrite
    public synchronized void func_71190_q() {
        Integer[] ids;
        this.field_71304_b.func_76320_a("levels");
        ChunkIOExecutor.tick();
        Integer[] integerArray = ids = DimensionManager.getIDs((this.field_71315_w % 200 == 0 ? 1 : 0) != 0);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int id = integerArray[i];
            long j = System.nanoTime();
            if (id == 0 || this.func_71255_r()) {
                WorldServer worldserver = DimensionManager.getWorld((int)id);
                this.field_71304_b.func_76320_a(worldserver.func_72912_H().func_76065_j());
                this.field_71304_b.func_76320_a("pools");
                this.field_71304_b.func_76319_b();
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a((Packet)new S03PacketTimeUpdate(worldserver.func_82737_E(), worldserver.func_72820_D(), worldserver.func_82736_K().func_82766_b("doDaylightCycle")), worldserver.field_73011_w.field_76574_g);
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                FMLCommonHandler.instance().onPreWorldTick((World)worldserver);
                try {
                    worldserver.func_72835_b();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Exception ticking world");
                    worldserver.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldserver.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception ticking world entities");
                    worldserver.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                FMLCommonHandler.instance().onPostWorldTick((World)worldserver);
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                worldserver.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.worldTickTimes.get((Object)Integer.valueOf((int)id))[this.field_71315_w % 100] = System.nanoTime() - j;
        }
        this.field_71304_b.func_76318_c("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.field_71304_b.func_76318_c("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            ((IUpdatePlayerListBox)this.field_71322_p.get(i)).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    @Shadow
    public boolean func_71255_r() {
        return true;
    }

    @Shadow
    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void run() {
        long passedTime;
        long lastTickTime;
        long currentTime;
        long l;
        long i;
        try {
            if (!this.func_71197_b()) {
                FMLCommonHandler.instance().expectServerStopped();
                this.func_71228_a(null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            i = MixinMinecraftServer.func_130071_aq();
            l = 0L;
            this.field_147147_p.func_151315_a((IChatComponent)new ChatComponentText(this.field_71286_C));
            this.field_147147_p.func_151321_a(new ServerStatusResponse.MinecraftProtocolVersionIdentifier("1.7.10", 5));
            this.func_147138_a(this.field_147147_p);
            int TICK_TIME = 50;
            lastTickTime = currentTime = MixinMinecraftServer.func_130071_aq();
            passedTime = 0L;
        }
        catch (StartupQuery.AbortedException e) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            optimizationsAndTweaks$logger.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                optimizationsAndTweaks$logger.error("This crash report has been saved to: %s", (Object)file1.getAbsolutePath());
            } else {
                optimizationsAndTweaks$logger.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                this.func_71260_j();
                this.field_71316_v = true;
            }
            catch (Throwable throwable) {
                optimizationsAndTweaks$logger.error("Exception stopping the server", throwable);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.field_71316_v = true;
                this.func_71240_o();
            }
        }
        while (true) {
            if (!this.field_71317_u) {
                FMLCommonHandler.instance().handleServerStopping();
                FMLCommonHandler.instance().expectServerStopped();
                return;
            }
            currentTime = MixinMinecraftServer.func_130071_aq();
            long deltaTime = currentTime - lastTickTime;
            lastTickTime = currentTime;
            passedTime += deltaTime;
            long j = MixinMinecraftServer.func_130071_aq();
            long k = j - i;
            if (k > 2000L && i - this.field_71299_R >= 15000L) {
                optimizationsAndTweaks$logger.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{k, k / 50L});
                k = 2000L;
                this.field_71299_R = i;
            }
            if (k < 0L) {
                optimizationsAndTweaks$logger.warn("Time ran backwards! Did the system time change?");
                k = 0L;
            }
            l += k;
            i = j;
            if (this.field_71305_c[0].func_73056_e()) {
                this.func_71217_p();
                passedTime = 0L;
            } else {
                while (passedTime >= 50L) {
                    this.func_71217_p();
                    passedTime -= 50L;
                }
            }
            TimeUnit.MILLISECONDS.sleep(Math.max(1L, 50L - l));
            this.field_71296_Q = true;
        }
    }

    @Shadow
    public static long func_130071_aq() {
        return System.currentTimeMillis();
    }

    @Shadow
    protected abstract boolean func_71197_b() throws IOException;

    @Shadow
    public void func_71260_j() {
        if (!this.field_71290_O && Loader.instance().hasReachedState(LoaderState.SERVER_STARTED) && !this.field_71316_v) {
            optimizationsAndTweaks$logger.info("Stopping server");
            if (this.func_147137_ag() != null) {
                this.func_147137_ag().func_151268_b();
            }
            if (this.field_71318_t != null) {
                optimizationsAndTweaks$logger.info("Saving players");
                this.field_71318_t.func_72389_g();
                this.field_71318_t.func_72392_r();
            }
            if (this.field_71305_c != null) {
                WorldServer[] tmp;
                optimizationsAndTweaks$logger.info("Saving worlds");
                this.func_71267_a(false);
                for (WorldServer worldserver : this.field_71305_c) {
                    MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)worldserver));
                    worldserver.func_73041_k();
                }
                for (WorldServer world : tmp = this.field_71305_c) {
                    DimensionManager.setWorld((int)world.field_73011_w.field_76574_g, null);
                }
            }
            if (this.field_71307_n.func_76468_d()) {
                this.field_71307_n.func_76470_e();
            }
        }
    }

    @Shadow
    protected void func_71228_a(CrashReport report) {
    }

    @Overwrite
    public void func_71267_a(boolean dontLog) {
        if (!this.field_71290_O) {
            WorldServer[] aworldserver = this.field_71305_c;
            if (aworldserver == null) {
                return;
            }
            for (WorldServer worldserver : aworldserver) {
                if (worldserver == null) continue;
                if (!dontLog) {
                    optimizationsAndTweaks$logger.info("Saving chunks for level '" + worldserver.func_72912_H().func_76065_j() + "'/" + worldserver.field_73011_w.func_80007_l());
                }
                try {
                    worldserver.func_73044_a(true, null);
                }
                catch (MinecraftException minecraftexception) {
                    optimizationsAndTweaks$logger.warn(minecraftexception.getMessage());
                }
            }
        }
    }

    @Overwrite
    public CrashReport func_71230_b(CrashReport report) {
        report.func_85056_g().func_71500_a("Profiler Position", () -> this.field_71304_b.field_76327_a ? this.field_71304_b.func_76322_c() : "N/A (disabled)");
        if (this.field_71305_c != null && this.field_71305_c.length > 0 && this.field_71305_c[0] != null) {
            report.func_85056_g().func_71500_a("Vec3 Pool Size", () -> {
                int b0 = 0;
                int i = 56 * b0;
                int j = i / 1024 / 1024;
                int b1 = 0;
                int k = 56 * b1;
                int l = k / 1024 / 1024;
                return b0 + " (" + i + " bytes; " + j + " MB) allocated, " + b1 + " (" + k + " bytes; " + l + " MB) used";
            });
        }
        if (this.field_71318_t != null) {
            report.func_85056_g().func_71500_a("Player Count", () -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.field_72404_b);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void func_147138_a(ServerStatusResponse response) {
        File file1 = this.func_71209_f("server-icon.png");
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                try (ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(bytebuf);){
                    ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)byteBufOutputStream);
                }
                ByteBuf bytebuf1 = Base64.encode((ByteBuf)bytebuf);
                response.func_151320_a("data:image/png;base64," + bytebuf1.toString(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                optimizationsAndTweaks$logger.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @Shadow
    public File func_71209_f(String fileName) {
        return new File(this.func_71238_n(), fileName);
    }

    @Shadow
    protected File func_71238_n() {
        return new File(".");
    }

    @Overwrite
    public synchronized void func_71217_p() {
        long i = System.nanoTime();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.field_71315_w;
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_71304_b.field_76327_a = true;
            this.field_71304_b.func_76317_a();
        }
        this.field_71304_b.func_76320_a("root");
        this.func_71190_q();
        if (i - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = i;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.PlayerCountData(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int j = MathHelper.func_76136_a((Random)this.field_147146_q, (int)0, (int)(this.func_71233_x() - agameprofile.length));
            for (int k = 0; k < agameprofile.length; ++k) {
                agameprofile[k] = ((EntityPlayerMP)this.field_71318_t.field_72404_b.get(j + k)).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.field_147147_p.func_151318_b().func_151330_a(agameprofile);
        }
        if (this.field_71315_w % 900 == 0) {
            this.field_71304_b.func_76320_a("save");
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("SaveThread-%d").build();
            CompletableFuture<Void> savePlayerDataFuture = CompletableFuture.runAsync(() -> this.field_71318_t.func_72389_g(), Executors.newCachedThreadPool(namedThreadFactory));
            CompletableFuture<Void> saveWorldsFuture = CompletableFuture.runAsync(() -> this.func_71267_a(true), Executors.newCachedThreadPool(namedThreadFactory));
            CompletableFuture.allOf(savePlayerDataFuture, saveWorldsFuture).join();
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_76320_a("tallying");
        this.field_71311_j[this.field_71315_w % 100] = System.nanoTime() - i;
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76319_b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    @Shadow
    protected void func_71240_o() {
    }

    @Shadow
    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    @Shadow
    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    @Overwrite
    public void func_71256_s() {
        StartupQuery.reset();
        new Thread(this::run, "Server thread").start();
    }
}

