/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.fantasticfish;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fantastic.FantasticIds;
import fantastic.entities.EntityBasicFish;
import fantastic.entities.EntityCaveFish;
import fantastic.entities.EntityFeeder;
import fantastic.entities.EntityMossy;
import fantastic.entities.EntitySalmon;
import fantastic.entities.EntityTuna;
import fantastic.entities.sharks.EntityBasicShark;
import fantastic.events.FantasticEvents;
import fantastic.proxies.CommonProxy;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FantasticEvents.class})
public class MixinFantasticEvents {
    @Shadow
    public static CommonProxy proxy = new CommonProxy();
    @Shadow
    Random rand = new Random();
    @Shadow
    private int texture = 0;

    @Unique
    boolean isBlockLoaded(World world, int x, int y, int z) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        return chunk.field_76636_d;
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent event) {
        EntityBasicFish Fish;
        if (!this.isBlockLoaded(event.world, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v)) {
            return;
        }
        if (event.entity instanceof EntityBasicShark && this.rand.nextInt(10) <= 8) {
            event.entity.func_70106_y();
        }
        float renderSize = 0.9f;
        int waters = 0;
        for (int k = -10; k <= 10; ++k) {
            if (event.world.func_147439_a((int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v + k) != Blocks.field_150355_j) continue;
            ++waters;
        }
        if (waters <= FantasticIds.tier1Depth) {
            renderSize = this.rand.nextInt(101 - FantasticIds.smallSpawnRate) <= 1 ? 0.5f : 0.25f;
        } else if (waters <= FantasticIds.tier2Depth) {
            renderSize = this.rand.nextInt(101 - FantasticIds.mediumSpawnRate) <= 1 ? 0.8f : 0.5f;
        } else if (waters <= FantasticIds.tier3Depth) {
            renderSize = this.rand.nextInt(101 - FantasticIds.smallSpawnRate) <= 1 ? 0.5f : (this.rand.nextInt(101 - FantasticIds.mediumSpawnRate) <= 1 ? 0.8f : (this.rand.nextInt(101 - FantasticIds.bigSpawnRate) <= 1 ? 1.0f : 0.8f));
        } else if (waters <= FantasticIds.tier4Depth) {
            renderSize = this.rand.nextInt(101 - FantasticIds.mediumSpawnRate) <= 1 ? 0.8f : (this.rand.nextInt(101 - FantasticIds.bigSpawnRate) <= 1 ? 1.0f : (this.rand.nextInt(101 - FantasticIds.largeSpawnRate) <= 1 ? 1.3f : 0.8f));
        } else if (waters > FantasticIds.tier5Depth) {
            renderSize = this.rand.nextInt(101 - FantasticIds.mediumSpawnRate) <= 1 ? 0.8f : (this.rand.nextInt(101 - FantasticIds.bigSpawnRate) <= 1 ? 1.0f : (this.rand.nextInt(101 - FantasticIds.largeSpawnRate) <= 1 ? 1.3f : (this.rand.nextInt(101 - FantasticIds.legendarySpawnRate) <= 1 ? 1.8f : 1.0f)));
        }
        if (event.entity instanceof EntityBasicFish && (Fish = (EntityBasicFish)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
        if (event.entity instanceof EntityCaveFish && (Fish = (EntityCaveFish)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
        if (event.entity instanceof EntitySalmon && (Fish = (EntitySalmon)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
        if (event.entity instanceof EntityFeeder && (Fish = (EntityFeeder)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
        if (event.entity instanceof EntityMossy && (Fish = (EntityMossy)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
        if (event.entity instanceof EntityTuna && (Fish = (EntityTuna)event.entity).getRenderSize() == 0.9f) {
            Fish.setRenderSize(renderSize);
            if (Fish.getRenderSize() == 0.9f) {
                Fish.setRenderSize(0.8f);
            }
        }
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void onSpawnEvent(EntityJoinWorldEvent event) {
        EntityFeeder Feeder;
        EntityBasicFish Fish;
        if (!this.isBlockLoaded(event.world, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v)) {
            return;
        }
        float renderSize = 0.9f;
        if (event.entity instanceof EntityBasicFish && (Fish = (EntityBasicFish)event.entity).getHasNotSpawned()) {
            if (this.rand.nextInt(10) == 0) {
                Fish.setRenderSize(1.8f);
            } else if (this.rand.nextInt(9) == 0) {
                Fish.setRenderSize(1.3f);
            } else if (this.rand.nextInt(5) == 0) {
                Fish.setRenderSize(1.0f);
            } else if (this.rand.nextInt(4) == 0) {
                Fish.setRenderSize(0.8f);
            } else if (this.rand.nextInt(2) == 0) {
                Fish.setRenderSize(0.5f);
            } else {
                Fish.setRenderSize(0.25f);
            }
            BiomeGenBase spawnBiome = event.entity.field_70170_p.func_72807_a((int)Fish.field_70165_t, (int)Fish.field_70161_v);
            this.texture = spawnBiome != BiomeGenBase.field_76782_w && spawnBiome != BiomeGenBase.field_76792_x && spawnBiome != BiomeGenBase.field_150589_Z && spawnBiome != BiomeGenBase.field_150608_ab && spawnBiome != BiomeGenBase.field_150607_aa ? (spawnBiome == BiomeGenBase.field_76780_h ? (this.rand.nextInt(11) == 0 ? 0 : (this.rand.nextInt(2) == 0 ? 4 : 1)) : (spawnBiome != BiomeGenBase.field_76771_b && spawnBiome != BiomeGenBase.field_150575_M ? (spawnBiome != BiomeGenBase.field_76789_p && spawnBiome != BiomeGenBase.field_76788_q ? (this.rand.nextInt(2) == 0 ? 4 : 1) : (this.rand.nextInt(11) == 0 ? 5 : (this.rand.nextInt(2) == 0 ? 4 : 1))) : (this.rand.nextInt(11) == 0 ? 3 : (this.rand.nextInt(2) == 0 ? 4 : 1)))) : (this.rand.nextInt(11) == 0 ? 2 : (this.rand.nextInt(2) == 0 ? 4 : 1));
            Fish.setTexture(this.texture);
            Fish.setHasNotSpawned(false);
        }
        if (event.entity instanceof EntityCaveFish) {
            EntityCaveFish CaveFish = (EntityCaveFish)event.entity;
            if (CaveFish.getHasNotSpawned()) {
                CaveFish.setRenderSize(renderSize);
                if (CaveFish.field_70163_u > 40.0 && event.world.func_72890_a((Entity)CaveFish, 5.0) == null) {
                    CaveFish.func_70106_y();
                }
            }
            CaveFish.setHasNotSpawned(false);
        }
        if (event.entity instanceof EntitySalmon) {
            EntitySalmon Salmon = (EntitySalmon)event.entity;
            if (Salmon.getHasNotSpawned()) {
                Salmon.setRenderSize(renderSize);
            }
            Salmon.setHasNotSpawned(false);
        }
        if (event.entity instanceof EntityFeeder) {
            Feeder = (EntityFeeder)event.entity;
            if (Feeder.getHasNotSpawned()) {
                Feeder.setRenderSize(renderSize);
            }
            Feeder.setHasNotSpawned(false);
        }
        if (event.entity instanceof EntityMossy) {
            Feeder = (EntityMossy)event.entity;
            if (Feeder.getHasNotSpawned()) {
                Feeder.setRenderSize(renderSize);
            }
            Feeder.setHasNotSpawned(false);
        }
        if (event.entity instanceof EntityTuna) {
            Feeder = (EntityTuna)event.entity;
            if (Feeder.getHasNotSpawned()) {
                Feeder.setRenderSize(renderSize);
            }
            Feeder.setHasNotSpawned(false);
        }
    }
}

