/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.ic2;

import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import ic2.core.util.Config;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={Config.class})
public class MixinConfig {
    @Overwrite
    private static List<String> split(String str, char splitChar) {
        if (OptimizationsandTweaksConfig.enableMixinConfig) {
            ArrayList<String> ret = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            boolean empty = true;
            boolean passNext = false;
            boolean quoted = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (passNext) {
                    current.append(c);
                    empty = false;
                    passNext = false;
                    continue;
                }
                if (c == '\\') {
                    current.append(c);
                    empty = false;
                    passNext = true;
                    continue;
                }
                if (c == '\"') {
                    current.append(c);
                    empty = false;
                    quoted = !quoted;
                    continue;
                }
                if (!quoted && c == splitChar) {
                    ret.add(current.toString().trim());
                    current = new StringBuilder();
                    empty = true;
                    continue;
                }
                if (Character.isWhitespace(c) && empty) continue;
                current.append(c);
                empty = false;
            }
            ret.add(current.toString().trim());
            return ret;
        }
        return null;
    }
}

