/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.minefactoryreloaded;

import fr.iamacat.optimizationsandtweaks.utilsformods.minefactoryreloaded.WorldGenRubberTree2;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.world.WorldGenRubberTree;

@Mixin(value={WorldGenRubberTree.class})
public abstract class MixinFixRubberTreesCascadingWorldgenLag
extends WorldGenerator {
    @Overwrite(remap=false)
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int numAttempts = 4;
        for (int attempt = 0; attempt < numAttempts; ++attempt) {
            int surfaceY = WorldGenRubberTree2.optimizationsAndTweaks$getSurfaceBlockY(world, x, z);
            if (surfaceY > 0) {
                int zOffset;
                int xOffset = attempt == 0 ? x : x + rand.nextInt(16) - 8;
                int n = zOffset = attempt == 0 ? z : z + rand.nextInt(16) - 8;
                if (this.growTree(world, rand, xOffset, surfaceY + 1, zOffset)) {
                    return true;
                }
            }
            x += rand.nextInt(16) - 8;
            z += rand.nextInt(16) - 8;
        }
        return false;
    }

    @Overwrite(remap=false)
    public boolean growTree(World world, Random rand, int x, int y, int z) {
        int worldHeight;
        if (this.optimizationsAndTweaks$shouldNotGrowTree(rand)) {
            return false;
        }
        int treeHeight = rand.nextInt(3) + 5;
        if (this.optimizationsAndTweaks$isInvalidTreePosition(world, x, y, z, treeHeight, worldHeight = world.func_72800_K())) {
            return false;
        }
        this.optimizationsAndTweaks$placeRubberWoodBlocks(world, x, y, z, treeHeight);
        WorldGenRubberTree2 worldGenRubberTree2 = new WorldGenRubberTree2();
        worldGenRubberTree2.generateLeaves(world, rand, x, y, z, treeHeight);
        return true;
    }

    @Unique
    private boolean optimizationsAndTweaks$shouldNotGrowTree(Random rand) {
        return rand.nextInt(2) == 0;
    }

    @Unique
    private boolean optimizationsAndTweaks$isInvalidTreePosition(World world, int x, int y, int z, int treeHeight, int worldHeight) {
        return y < 1 || y + treeHeight + 1 > worldHeight || !this.optimizationsAndTweaks$placeSapling(world, x, y, z);
    }

    @Unique
    private void optimizationsAndTweaks$placeRubberWoodBlocks(World world, int x, int y, int z, int treeHeight) {
        Chunk chunk = world.func_72938_d(x, z);
        for (int yOffset = 0; yOffset < treeHeight; ++yOffset) {
            int blockY = y + yOffset;
            if (chunk.func_150807_a(x & 0xF, blockY, z & 0xF, MFRThings.rubberWoodBlock, 0)) continue;
            chunk.func_150807_a(x & 0xF, blockY, z & 0xF, MFRThings.rubberWoodBlock, 0);
            this.optimizationsAndTweaks$notifyBlockUpdate(world, x, blockY, z, 0);
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$placeSapling(World world, int x, int y, int z) {
        BlockSapling sapling = MFRThings.rubberSaplingBlock;
        if (sapling.func_149742_c(world, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)sapling, 0, 2);
            return true;
        }
        return false;
    }

    @Unique
    private void optimizationsAndTweaks$notifyBlockUpdate(World world, int x, int y, int z, int meta) {
        world.func_147471_g(x, y, z);
        if (!world.field_72995_K) {
            world.func_147444_c(x, y, z, Block.func_149729_e((int)meta));
        }
    }
}

