/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.slimecarnage;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import supremopete.SlimeCarnage.commom.SlimeCarnage;
import supremopete.SlimeCarnage.mobs.EntityDonatelloSlime;
import supremopete.SlimeCarnage.mobs.EntityLeonardoSlime;
import supremopete.SlimeCarnage.mobs.EntityMichelangeloSlime;
import supremopete.SlimeCarnage.mobs.EntityRaphaelSlime;
import supremopete.SlimeCarnage.worldgen.WorldGenSewers;

@Mixin(value={WorldGenSewers.class})
public abstract class MixinWorldGenSewers {
    @Shadow
    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150349_c};
    }

    @Overwrite(remap=false)
    public boolean LocationIsValidSpawn(World world, int posX, int posY, int posZ) {
        int chunkX = posX >> 4;
        int chunkZ = posZ >> 4;
        int distanceToAir = this.optimizationsAndTweaks$calculateDistanceToAir(world, posX, posY, posZ);
        if (distanceToAir > 3) {
            return false;
        }
        if ((posY += distanceToAir - 1) >= world.func_72800_K()) {
            return false;
        }
        Block block = world.func_147439_a(posX, posY, posZ);
        Block blockBelow = world.func_147439_a(posX, posY - 1, posZ);
        Block[] validSpawnBlocks = this.GetValidSpawnBlocks();
        return this.optimizationsAndTweaks$isValidSpawnBlock(block, blockBelow, validSpawnBlocks);
    }

    @Unique
    private int optimizationsAndTweaks$calculateDistanceToAir(World world, int posX, int posY, int posZ) {
        Block currentBlock;
        int maxDistance = 3;
        int distance = 0;
        int chunkX = posX >> 4;
        int chunkZ = posZ >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int chunkMinY = Math.max(0, posY);
        int chunkMaxY = Math.min(world.func_72800_K(), posY + maxDistance);
        for (int y = chunkMinY; y < chunkMaxY && (currentBlock = chunk.func_150810_a(posX & 0xF, y, posZ & 0xF)) != Blocks.field_150350_a; ++y) {
            ++distance;
        }
        return distance;
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidSpawnBlock(Block block, Block blockBelow, Block[] validSpawnBlocks) {
        for (Block validBlock : validSpawnBlocks) {
            if (block != validBlock && (block != Blocks.field_150433_aE || blockBelow != validBlock)) continue;
            return true;
        }
        return false;
    }

    @Overwrite(remap=false)
    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        boolean allCornersInChunk;
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        boolean bl = allCornersInChunk = chunkX * 16 == i && chunkZ * 16 == k && this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 8, j, k) && this.LocationIsValidSpawn(world, i + 8, j, k + 4) && this.LocationIsValidSpawn(world, i, j, k + 4);
        if (i >= 0 && i < 16 && k >= 0 && k < 16 && j >= 0 && j < 256 && allCornersInChunk) {
            this.optimizationsAndTweaks$generate1(world, rand, i, j, k);
            this.optimizationsAndTweaks$generate2(world, rand, i, j, k);
            this.optimizationsAndTweaks$generate3(world, rand, i, j, k);
            this.optimizationsAndTweaks$generate4(world, rand, i, j, k);
            if (!world.field_72995_K) {
                this.optimizationsAndTweaks$generate5(world, rand, i, j, k);
            }
            return true;
        }
        return false;
    }

    @Unique
    public void optimizationsAndTweaks$generate1(World world, Random rand, int i, int j, int k) {
        int k3;
        int i3;
        int j3;
        int j4;
        for (j4 = -15; j4 < 1; ++j4) {
            for (j3 = 0; j3 < 5; ++j3) {
                for (i3 = 0; i3 < 5; ++i3) {
                    k3 = rand.nextInt(5);
                    if (k3 >= 0 || k3 <= 2) {
                        world.func_147449_b(i + j3, j + j4, k + i3, Blocks.field_150417_aV);
                    }
                    if (k3 == 3) {
                        world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 1, 2);
                    }
                    if (k3 != 4) continue;
                    world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        for (j4 = -12; j4 < 0; ++j4) {
            for (j3 = 1; j3 < 4; ++j3) {
                for (i3 = 1; i3 < 4; ++i3) {
                    world.func_147449_b(i + j3, j + j4, k + i3, Blocks.field_150350_a);
                }
            }
        }
        for (j4 = -15; j4 < -8; ++j4) {
            for (j3 = 13; j3 < 25; ++j3) {
                for (i3 = -4; i3 < 32; ++i3) {
                    k3 = rand.nextInt(5);
                    if (k3 >= 0 || k3 <= 2) {
                        world.func_147449_b(i + j3, j + j4, k + i3, Blocks.field_150417_aV);
                    }
                    if (k3 == 3) {
                        world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 1, 2);
                    }
                    if (k3 != 4) continue;
                    world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        for (j4 = -15; j4 < -8; ++j4) {
            for (j3 = 0; j3 < 23; ++j3) {
                for (i3 = -4; i3 < 9; ++i3) {
                    k3 = rand.nextInt(5);
                    if (k3 >= 0 || k3 <= 2) {
                        world.func_147449_b(i + j3, j + j4, k + i3, Blocks.field_150417_aV);
                    }
                    if (k3 == 3) {
                        world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 1, 2);
                    }
                    if (k3 != 4) continue;
                    world.func_147465_d(i + j3, j + j4, k + i3, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        world.func_147449_b(i, j + 1, k + 2, Blocks.field_150417_aV);
        world.func_147449_b(i + 1, j, k + 2, Blocks.field_150350_a);
        world.func_147449_b(i + 1, j - 10, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 10, k + 2, Blocks.field_150350_a);
        world.func_147449_b(i + 1, j - 10, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 10, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 10, k + 2, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 10, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 10, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 10, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 1, j - 9, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 9, k + 2, Blocks.field_150350_a);
        world.func_147449_b(i + 1, j - 9, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 9, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 9, k + 2, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 9, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 9, k + 1, Blocks.field_150350_a);
        world.func_147449_b(i + 3, j - 9, k + 3, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 14, k, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 14, k, Blocks.field_150355_j);
        world.func_147449_b(i + 2, j - 14, k - 1, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 14, k - 1, Blocks.field_150355_j);
        world.func_147449_b(i + 2, j - 13, k - 2, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 13, k - 2, Blocks.field_150355_j);
        world.func_147449_b(i + 2, j - 13, k - 3, Blocks.field_150350_a);
        world.func_147449_b(i + 2, j - 13, k - 3, Blocks.field_150411_aY);
        world.func_147449_b(i + 2, j - 13, k - 4, Blocks.field_150350_a);
    }

    @Unique
    public void optimizationsAndTweaks$generate2(World world, Random rand, int i, int j, int k) {
        int k3;
        int i3;
        int j3;
        world.func_147449_b(i + 2, j - 13, k - 4, (Block)Blocks.field_150486_ae);
        TileEntityChest tileentitychest = new TileEntityChest();
        world.func_147455_a(i + 2, j - 13, k - 4, (TileEntity)tileentitychest);
        for (j3 = 0; j3 < 6; ++j3) {
            ItemStack itemstack2 = this.pickCheckLootItem(rand);
            if (itemstack2 == null) continue;
            tileentitychest.func_70299_a(rand.nextInt(tileentitychest.func_70302_i_()), itemstack2);
        }
        world.func_147449_b(i + 19, j - 14, k, Blocks.field_150350_a);
        world.func_147449_b(i + 19, j - 14, k, Blocks.field_150355_j);
        world.func_147449_b(i + 19, j - 14, k - 1, Blocks.field_150350_a);
        world.func_147449_b(i + 19, j - 14, k - 1, Blocks.field_150355_j);
        world.func_147449_b(i + 19, j - 13, k - 2, Blocks.field_150350_a);
        world.func_147449_b(i + 19, j - 13, k - 2, Blocks.field_150355_j);
        world.func_147449_b(i + 19, j - 13, k - 3, Blocks.field_150350_a);
        world.func_147449_b(i + 19, j - 13, k - 3, Blocks.field_150411_aY);
        world.func_147449_b(i + 19, j - 13, k - 4, Blocks.field_150350_a);
        for (j3 = -15; j3 < -8; ++j3) {
            for (i3 = 8; i3 < 15; ++i3) {
                for (k3 = -8; k3 < 0; ++k3) {
                    int j8 = rand.nextInt(5);
                    if (j8 >= 0 || j8 <= 2) {
                        world.func_147449_b(i + i3, j + j3, k + k3, Blocks.field_150417_aV);
                    }
                    if (j8 == 3) {
                        world.func_147465_d(i + i3, j + j3, k + k3, Blocks.field_150417_aV, 1, 2);
                    }
                    if (j8 != 4) continue;
                    world.func_147465_d(i + i3, j + j3, k + k3, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        for (j3 = -13; j3 < -10; ++j3) {
            for (i3 = 10; i3 < 13; ++i3) {
                for (k3 = -5; k3 < -2; ++k3) {
                    world.func_147449_b(i + i3, j + j3, k + k3, Blocks.field_150350_a);
                }
            }
        }
        world.func_147449_b(i + 10, j - 11, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 11, j - 11, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 12, j - 11, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 10, j - 12, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 11, j - 12, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 12, j - 12, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 10, j - 13, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 11, j - 13, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 12, j - 13, k - 2, Blocks.field_150411_aY);
        world.func_147449_b(i + 11, j - 14, k, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 14, k - 1, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k - 1, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 14, k - 2, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k - 2, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 14, k - 3, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k - 3, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 14, k - 4, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k - 4, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 14, k - 5, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 14, k - 5, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 12, k - 6, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 12, k - 6, Blocks.field_150355_j);
        world.func_147449_b(i + 11, j - 12, k - 7, Blocks.field_150350_a);
        world.func_147449_b(i + 11, j - 12, k - 7, Blocks.field_150411_aY);
        world.func_147449_b(i + 8, j - 12, k - 3, Blocks.field_150474_ac);
        TileEntityMobSpawner tileentitymobspawner1 = (TileEntityMobSpawner)world.func_147438_o(i + 8, j - 12, k - 3);
        tileentitymobspawner1.func_145881_a().func_98272_a("SlimeCarnage.FootSoldierSlime");
        world.func_147449_b(i + 14, j - 12, k - 3, Blocks.field_150474_ac);
        TileEntityMobSpawner tileentitymobspawner2 = (TileEntityMobSpawner)world.func_147438_o(i + 14, j - 12, k - 3);
        tileentitymobspawner2.func_145881_a().func_98272_a("SlimeCarnage.FootSoldierSlime");
        world.func_147449_b(i + 19, j - 13, k - 4, (Block)Blocks.field_150486_ae);
        TileEntityChest tileentitychest2 = new TileEntityChest();
        world.func_147455_a(i + 19, j - 13, k - 4, (TileEntity)tileentitychest2);
        for (int j8 = 0; j8 < 6; ++j8) {
            ItemStack itemstack2 = this.pickCheckLootItem(rand);
            if (itemstack2 == null) continue;
            tileentitychest2.func_70299_a(rand.nextInt(tileentitychest.func_70302_i_()), itemstack2);
        }
    }

    @Unique
    public void optimizationsAndTweaks$generate3(World world, Random rand, int i, int j, int k) {
        int h;
        int k8;
        int i8;
        int j8;
        for (j8 = 16; j8 < 23; ++j8) {
            for (i8 = 23; i8 < 30; ++i8) {
                world.func_147449_b(i + j8, j - 10, k + i8, Blocks.field_150350_a);
            }
        }
        for (j8 = -20; j8 < -10; ++j8) {
            for (i8 = 21; i8 < 28; ++i8) {
                for (k8 = -3; k8 < 8; ++k8) {
                    h = rand.nextInt(5);
                    if (h >= 0 || h <= 2) {
                        world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150417_aV);
                    }
                    if (h == 3) {
                        world.func_147465_d(i + i8, j + j8, k + k8, Blocks.field_150417_aV, 1, 2);
                    }
                    if (h != 4) continue;
                    world.func_147465_d(i + i8, j + j8, k + k8, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        for (j8 = -20; j8 < -13; ++j8) {
            for (i8 = 23; i8 < 46; ++i8) {
                for (k8 = -4; k8 < 9; ++k8) {
                    h = rand.nextInt(5);
                    if (h >= 0 || h <= 2) {
                        world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150417_aV);
                    }
                    if (h == 3) {
                        world.func_147465_d(i + i8, j + j8, k + k8, Blocks.field_150417_aV, 1, 2);
                    }
                    if (h != 4) continue;
                    world.func_147465_d(i + i8, j + j8, k + k8, Blocks.field_150417_aV, 2, 2);
                }
            }
        }
        for (j8 = -14; j8 < -13; ++j8) {
            for (i8 = 2; i8 < 25; ++i8) {
                for (k8 = 1; k8 < 4; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150355_j);
                }
            }
        }
        for (j8 = -14; j8 < -13; ++j8) {
            for (i8 = 18; i8 < 21; ++i8) {
                for (k8 = 1; k8 < 21; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150355_j);
                }
            }
        }
        for (j8 = -19; j8 < -18; ++j8) {
            for (i8 = 23; i8 < 46; ++i8) {
                for (k8 = 1; k8 < 4; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150355_j);
                }
            }
        }
        for (j8 = -13; j8 < -10; ++j8) {
            for (i8 = 1; i8 < 23; ++i8) {
                for (k8 = -1; k8 < 6; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                }
            }
        }
        for (j8 = -13; j8 < -10; ++j8) {
            for (i8 = 16; i8 < 23; ++i8) {
                for (k8 = -1; k8 < 30; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                }
            }
        }
        for (j8 = -18; j8 < -15; ++j8) {
            for (i8 = 23; i8 < 46; ++i8) {
                for (k8 = -1; k8 < 6; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                }
            }
        }
        for (j8 = -18; j8 < -10; ++j8) {
            for (i8 = 23; i8 < 26; ++i8) {
                for (k8 = -1; k8 < 6; ++k8) {
                    world.func_147449_b(i + i8, j + j8, k + k8, Blocks.field_150350_a);
                }
            }
        }
        for (j8 = -13; j8 < 1; ++j8) {
            world.func_147449_b(i + 1, j + j8, k + 2, Blocks.field_150468_ap);
            world.func_72921_c(i + 1, j + j8, k + 2, 5, 2);
        }
    }

    @Unique
    public void optimizationsAndTweaks$generate4(World world, Random rand, int i, int j, int k) {
        world.func_147465_d(i + 16, j - 13, k + 22, Blocks.field_150417_aV, 1, 2);
        world.func_147449_b(i + 16, j - 12, k + 22, Blocks.field_150417_aV);
        world.func_147449_b(i + 16, j - 11, k + 22, Blocks.field_150417_aV);
        world.func_147449_b(i + 17, j - 13, k + 22, Blocks.field_150417_aV);
        world.func_147449_b(i + 17, j - 12, k + 22, Blocks.field_150417_aV);
        world.func_147465_d(i + 17, j - 11, k + 22, Blocks.field_150417_aV, 1, 2);
        world.func_147449_b(i + 18, j - 11, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 18, j - 12, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 18, j - 13, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 19, j - 11, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 19, j - 12, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 19, j - 13, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 20, j - 11, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 20, j - 12, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 20, j - 13, k + 22, Blocks.field_150411_aY);
        world.func_147449_b(i + 21, j - 13, k + 22, Blocks.field_150417_aV);
        world.func_147449_b(i + 21, j - 12, k + 22, Blocks.field_150417_aV);
        world.func_147465_d(i + 21, j - 11, k + 22, Blocks.field_150417_aV, 1, 2);
        world.func_147449_b(i + 22, j - 13, k + 22, Blocks.field_150417_aV);
        world.func_147449_b(i + 22, j - 12, k + 22, Blocks.field_150417_aV);
        world.func_147465_d(i + 22, j - 11, k + 22, Blocks.field_150417_aV, 2, 2);
    }

    @Unique
    public void optimizationsAndTweaks$generate5(World world, Random rand, int i, int j, int k) {
        EntityLeonardoSlime leoslime = new EntityLeonardoSlime(world);
        leoslime.func_70012_b((double)(i + 17), (double)(j - 12), (double)(k + 24), 0.0f, 0.0f);
        world.func_72838_d((Entity)leoslime);
        EntityDonatelloSlime donslime = new EntityDonatelloSlime(world);
        donslime.func_70012_b((double)(i + 21), (double)(j - 12), (double)(k + 24), 0.0f, 0.0f);
        world.func_72838_d((Entity)donslime);
        EntityRaphaelSlime raphslime = new EntityRaphaelSlime(world);
        raphslime.func_70012_b((double)(i + 17), (double)(j - 12), (double)(k + 26), 0.0f, 0.0f);
        world.func_72838_d((Entity)raphslime);
        EntityMichelangeloSlime micslime = new EntityMichelangeloSlime(world);
        micslime.func_70012_b((double)(i + 21), (double)(j - 12), (double)(k + 26), 0.0f, 0.0f);
        world.func_72838_d((Entity)micslime);
    }

    @Shadow
    private ItemStack pickCheckLootItem(Random random) {
        int i = random.nextInt(31);
        if (i == 0) {
            return new ItemStack(SlimeCarnage.PizzaSlice, random.nextInt(2) + 1);
        }
        if (i == 1) {
            return new ItemStack(SlimeCarnage.Banana, random.nextInt(2) + 1);
        }
        if (i == 2 && random.nextInt(200) == 0) {
            return null;
        }
        if (i == 3) {
            return null;
        }
        if (i == 4) {
            return new ItemStack(Items.field_151133_ar, 1);
        }
        if (i == 5) {
            return new ItemStack(SlimeCarnage.LimeJam, random.nextInt(4) + 1);
        }
        if (i == 6) {
            return new ItemStack(Items.field_151062_by, random.nextInt(20) + 1);
        }
        if (i == 7 && random.nextInt(5) == 0) {
            return new ItemStack(Items.field_151057_cb, 1);
        }
        if (i == 8) {
            return new ItemStack(Items.field_151043_k, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Items.field_151093_ce, 1);
        }
        if (i == 10) {
            return new ItemStack(Items.field_151042_j, random.nextInt(4) + 1);
        }
        if (i == 11 && random.nextInt(20) == 0) {
            return new ItemStack(SlimeCarnage.GreenGelBoots, 1);
        }
        if (i == 12 && random.nextInt(20) == 0) {
            return new ItemStack(SlimeCarnage.GreenGelLeggings, 1);
        }
        if (i == 13 && random.nextInt(20) == 0) {
            return new ItemStack(SlimeCarnage.GreenGelChestplate, 1);
        }
        if (i == 14 && random.nextInt(20) == 0) {
            return new ItemStack(SlimeCarnage.GreenGelHelmet, 1);
        }
        if (i == 15 && random.nextInt(3) == 0) {
            return new ItemStack(SlimeCarnage.BlueGel, random.nextInt(12) + 1);
        }
        if (i == 16 && random.nextInt(3) == 0) {
            return new ItemStack(SlimeCarnage.RedGel, random.nextInt(12) + 1);
        }
        if (i == 17 && random.nextInt(3) == 0) {
            return new ItemStack(SlimeCarnage.YellowGel, random.nextInt(12) + 1);
        }
        if (i == 18 && random.nextInt(3) == 0) {
            return new ItemStack(SlimeCarnage.GreenGel, random.nextInt(12) + 1);
        }
        if (i == 19) {
            return new ItemStack(SlimeCarnage.OrangeGel, random.nextInt(12) + 1);
        }
        if (i == 20) {
            return new ItemStack(SlimeCarnage.ScrollField, 1);
        }
        if (i == 21) {
            return new ItemStack(SlimeCarnage.ScrollChurch, 1);
        }
        if (i == 22) {
            return new ItemStack(SlimeCarnage.ScrollWell, 1);
        }
        if (i == 23) {
            return new ItemStack(SlimeCarnage.ScrollBlacksmith, 1);
        }
        if (i == 24) {
            return new ItemStack(SlimeCarnage.ScrollHouse1, 1);
        }
        if (i == 25) {
            return new ItemStack(SlimeCarnage.ScrollHouse2, 1);
        }
        if (i == 26 && random.nextInt(10) == 0) {
            return new ItemStack(SlimeCarnage.ScrollHouse3, 1);
        }
        if (i == 27 && random.nextInt(10) == 0) {
            return new ItemStack(SlimeCarnage.ScrollHouse4, 1);
        }
        if (i == 28) {
            return new ItemStack(Items.field_151032_g, 16);
        }
        if (i == 29) {
            return new ItemStack(Items.field_151153_ao, 1);
        }
        return i == 30 ? new ItemStack(Items.field_151123_aH, 4) : null;
    }
}

