/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thaumcraft;

import fr.iamacat.optimizationsandtweaks.utilsformods.thaumcraft.BiomeGenMagicalForest2;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.world.WorldGenManaPods;
import thaumcraft.common.lib.world.biomes.BiomeGenMagicalForest;

@Mixin(value={BiomeGenMagicalForest.class})
public abstract class MixinPatchBiomeGenMagicalForest
extends BiomeGenBase {
    @Shadow
    private static final WorldGenBlockBlob blobs = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);

    public MixinPatchBiomeGenMagicalForest(int p_i1971_1_) {
        super(p_i1971_1_);
    }

    public void func_76728_a(World world, Random random, int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        if (!chunk.field_76636_d) {
            return;
        }
        this.optimizationsAndTweaks$generateBlobs(world, random, x, z);
        this.optimizationsAndTweaks$generateBigMushrooms(world, random, x, z);
        this.optimizationsAndTweaks$generateManaPods(world, random, x, z);
        this.optimizationsAndTweaks$generateCustomPlants(world, random, x, z);
        super.func_76728_a(world, random, x, z);
    }

    @Unique
    private void optimizationsAndTweaks$generateBlobs(World world, Random random, int x, int z) {
        for (int i = 0; i < 3; ++i) {
            int posX = x + random.nextInt(16) + 8;
            int posZ = z + random.nextInt(16) + 8;
            int posY = world.func_72976_f(posX, posZ);
            blobs.func_76484_a(world, random, posX, posY, posZ);
        }
    }

    @Unique
    private void optimizationsAndTweaks$generateBigMushrooms(World world, Random random, int x, int z) {
        for (int k = 0; k < 4; ++k) {
            for (int l = 0; l < 4; ++l) {
                int posX = x + k * 4 + 1 + 8 + random.nextInt(3);
                int posZ = z + l * 4 + 1 + 8 + random.nextInt(3);
                int posY = world.func_72976_f(posX, posZ);
                if (random.nextInt(40) != 0) continue;
                WorldGenBigMushroom worldgenbigmushroom = new WorldGenBigMushroom();
                worldgenbigmushroom.func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    @Unique
    private void optimizationsAndTweaks$generateManaPods(World world, Random random, int x, int z) {
        WorldGenManaPods worldgenpods = new WorldGenManaPods();
        for (int i = 0; i < 10; ++i) {
            int posX = x + random.nextInt(16) + 8;
            int posY = 64;
            int posZ = z + random.nextInt(16) + 8;
            worldgenpods.func_76484_a(world, random, posX, posY, posZ);
        }
    }

    @Unique
    private void optimizationsAndTweaks$generateCustomPlants(World world, Random random, int x, int z) {
        int worldHeight = world.func_72976_f(x, z);
        for (int i = 0; i < 8; ++i) {
            int posX = x + random.nextInt(16);
            int posZ = z + random.nextInt(16);
            while (worldHeight > 50 && world.func_147439_a(posX, worldHeight, posZ) != Blocks.field_150349_c) {
                --worldHeight;
            }
            if (world.func_147439_a(posX, worldHeight, posZ) != Blocks.field_150349_c || !world.func_147437_c(posX, worldHeight + 1, posZ) || !BiomeGenMagicalForest2.optimizationsAndTweaks$isAdjacentToWood(world, posX, worldHeight + 1, posZ)) continue;
            world.func_147465_d(posX, worldHeight + 1, posZ, ConfigBlocks.blockCustomPlant, 5, 2);
        }
    }
}

