/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.distribution;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.distribution.AbstractIntegerDistribution;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.NotStrictlyPositiveException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.OutOfRangeException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.util.Localizable;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.util.LocalizedFormats;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.random.RandomGenerator;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.random.Well19937c;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.special.Beta;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.util.CombinatoricsUtils;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int r, double p) throws NotStrictlyPositiveException, OutOfRangeException {
        this(new Well19937c(), r, p);
    }

    public PascalDistribution(RandomGenerator rng, int r, double p) throws NotStrictlyPositiveException, OutOfRangeException {
        super(rng);
        if (r <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, r);
        }
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        this.numberOfSuccesses = r;
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccess = FastMath.log(p);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 ? 0.0 : CombinatoricsUtils.binomialCoefficientDouble(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, x);
        return ret;
    }

    @Override
    public double logProbability(int x) {
        double ret = x < 0 ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)x;
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)x + 1.0);
        return ret;
    }

    @Override
    public double getNumericalMean() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / p;
    }

    @Override
    public double getNumericalVariance() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / (p * p);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

