/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.neuralnet.sofm;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.util.FastMath;

public class NeighbourhoodSizeFunctionFactory {
    private NeighbourhoodSizeFunctionFactory() {
    }

    public static NeighbourhoodSizeFunction exponentialDecay(final double initValue, final double valueAtNumCall, final long numCall) {
        return new NeighbourhoodSizeFunction(){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(initValue, valueAtNumCall, numCall);
            }

            @Override
            public int value(long n) {
                return (int)FastMath.rint(this.decay.value(n));
            }
        };
    }

    public static NeighbourhoodSizeFunction quasiSigmoidDecay(final double initValue, final double slope, final long numCall) {
        return new NeighbourhoodSizeFunction(){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(initValue, slope, numCall);
            }

            @Override
            public int value(long n) {
                return (int)FastMath.rint(this.decay.value(n));
            }
        };
    }
}

