/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.analysis.MultivariateVectorFunction;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.TooManyEvaluationsException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.ConvergenceChecker;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.OptimizationData;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.PointValuePair;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;

public abstract class GradientMultivariateOptimizer
extends MultivariateOptimizer {
    private MultivariateVectorFunction gradient;

    protected GradientMultivariateOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    protected double[] computeObjectiveGradient(double[] params) {
        return this.gradient.value(params);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (!(data instanceof ObjectiveFunctionGradient)) continue;
            this.gradient = ((ObjectiveFunctionGradient)data).getObjectiveFunctionGradient();
            break;
        }
    }
}

