/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utilsformods.industrialcraft2;

import com.google.common.collect.Iterators;
import ic2.core.util.PriorityExecutor;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class FixedPriorityQueue2<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Map<PriorityExecutor.Priority, Queue<E>> queues = new EnumMap<PriorityExecutor.Priority, Queue<E>>(PriorityExecutor.Priority.class);

    public FixedPriorityQueue2() {
        PriorityExecutor.Priority[] var1;
        for (PriorityExecutor.Priority priority : var1 = PriorityExecutor.Priority.values()) {
            this.queues.put(priority, new ArrayDeque());
        }
    }

    @Override
    public E poll() {
        Queue<E> queue;
        E ret;
        Iterator<Queue<E>> var1 = this.queues.values().iterator();
        do {
            if (var1.hasNext()) continue;
            return null;
        } while ((ret = (queue = var1.next()).poll()) == null);
        return ret;
    }

    @Override
    public E peek() {
        Queue<E> queue;
        E ret;
        Iterator<Queue<E>> var1 = this.queues.values().iterator();
        do {
            if (var1.hasNext()) continue;
            return null;
        } while ((ret = (queue = var1.next()).peek()) == null);
        return ret;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Queue<E> queue : this.queues.values()) {
            ret += queue.size();
        }
        return ret;
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList iterators = new ArrayList(this.queues.size());
        for (Queue<E> es : this.queues.values()) {
            iterators.add(es.iterator());
        }
        return Iterators.concat(iterators.iterator());
    }

    @Override
    public boolean offer(E e) {
        ArrayDeque queue = (ArrayDeque)this.queues.get(this.getPriority(e));
        queue.offer(e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    @Override
    public synchronized E take() throws InterruptedException {
        E ret = this.poll();
        while (ret == null) {
            this.wait();
            ret = this.poll();
        }
        return ret;
    }

    @Override
    public synchronized E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long duration;
        E ret = this.poll();
        if (ret != null) {
            return ret;
        }
        long endTime = System.nanoTime() + unit.toNanos(timeout);
        while ((duration = endTime - System.nanoTime()) > 0L) {
            this.wait(duration / 1000000L, (int)(duration % 1000000L));
            ret = this.poll();
            if (ret == null) continue;
        }
        return ret;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int ret = 0;
        for (Queue<E> es : this.queues.values()) {
            E x;
            while (ret < maxElements && (x = es.poll()) != null) {
                c.add(x);
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public void clear() {
        for (Queue<E> es : this.queues.values()) {
            es.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        Queue<E> queue;
        Iterator<Queue<E>> var2 = this.queues.values().iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!(queue = var2.next()).contains(o));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Queue<E> es : this.queues.values()) {
            if (!es.removeAll(c)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        for (Queue<E> es : this.queues.values()) {
            if (!es.retainAll(c)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return super.toArray(a);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        boolean added = false;
        for (E e : c) {
            Queue<E> queue = this.queues.get(this.getPriority(e));
            queue.offer(e);
            added = true;
        }
        if (added) {
            this.notifyAll();
        }
        return added;
    }

    private PriorityExecutor.Priority getPriority(E x) {
        return x instanceof PriorityExecutor.CustomPriority ? ((PriorityExecutor.CustomPriority)x).getPriority() : PriorityExecutor.Priority.Default;
    }
}

