/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.functions.GenericIterableFactory;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.command.ServerCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FMLServerHandler.class})
public abstract class MixinFMLServerHandler
implements IFMLSidedHandler {
    @Shadow
    private MinecraftServer server;

    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            FMLLog.warning((String)"%s", (Object[])new Object[]{query.getText()});
            query.finish();
        } else {
            String text = query.getText() + "\n\nRun the command /fml confirm or /fml cancel to proceed.\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
            FMLLog.warning((String)"%s", (Object[])new Object[]{text});
            if (!query.isSynchronous()) {
                return;
            }
            AtomicBoolean done = new AtomicBoolean(false);
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                while (!done.get() && this.server.func_71278_l()) {
                    if (Thread.interrupted()) {
                        query.finish();
                        return;
                    }
                    DedicatedServer dedServer = (DedicatedServer)this.server;
                    List list = dedServer.field_71341_l;
                    synchronized (list) {
                        Iterator it = GenericIterableFactory.newCastingIterable((Iterable)dedServer.field_71341_l, ServerCommand.class).iterator();
                        while (it.hasNext()) {
                            String cmd;
                            switch (cmd = ((ServerCommand)it.next()).field_73702_a.trim().toLowerCase()) {
                                case "/fml confirm": {
                                    FMLLog.info((String)"confirmed", (Object[])new Object[0]);
                                    query.setResult(true);
                                    done.set(true);
                                    it.remove();
                                    break;
                                }
                                case "/fml cancel": {
                                    FMLLog.info((String)"cancelled", (Object[])new Object[0]);
                                    query.setResult(false);
                                    done.set(true);
                                    it.remove();
                                    break;
                                }
                                case "/stop": {
                                    StartupQuery.abort();
                                }
                            }
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        query.finish();
                    }
                }
            });
            try {
                completableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            query.finish();
        }
    }
}

