/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.flaxbeardssteampower;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.entity.ExtendedPropertiesVillager;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.material.Material;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SteamcraftEventHandler.class})
public class MixinSteamcraftEventHandler {
    @Shadow
    public static boolean lastViewVillagerGui;
    @Shadow
    public static int use;
    @Shadow
    boolean lastWearing = false;
    @Shadow
    boolean worldStartUpdate = false;
    @Shadow
    private SPLog log;
    @Shadow
    private static boolean isShiftDown;
    @Shadow
    private static Field lastBuyingPlayerField;
    @Shadow
    private static Field timeUntilResetField;
    @Shadow
    private static Field merchantField;
    private static Field buyingListField;
    @Shadow
    List<DamageSource> invalidSources;
    @Shadow
    private int sideHit;
    @Shadow
    public static HashMap<MutablePair<Integer, Tuple3>, Integer> quickLavaBlocks;
    @Shadow
    public static HashMap<MutablePair<EntityPlayer, Tuple3>, Integer> charges;
    @Shadow
    public static final int PEACEFUL_CHARGE = 240;
    @Shadow
    public static final int EASY_CHARGE_CAP = 280;
    @Shadow
    public static final int EASY_CHARGE_MIN = 160;
    @Shadow
    public static final int NORMAL_CHARGE_CAP = 320;
    @Shadow
    public static final int NORMAL_CHARGE_MIN = 120;
    @Shadow
    public static final int HARD_CHARGE_CAP = 360;
    @Shadow
    public static final int HARD_CHARGE_MIN = 80;
    @Shadow
    private static int[][] extraBlocksSide;
    @Shadow
    private static int[][] extraBlocksForward;
    @Shadow
    private static int[][] extraBlocksVertical;
    @Shadow
    private static int[][] extraBlocks9Side;
    @Shadow
    private static int[][] extraBlocks9Forward;
    @Shadow
    private static int[][] extraBlocks9Vertical;
    @Shadow
    private ArrayList<Material> LEAF_MATERIALS;

    @Overwrite(remap=false)
    @SubscribeEvent
    public void updateVillagers(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)event.entityLiving;
        if (timeUntilResetField != null && lastBuyingPlayerField != null) {
            Integer timeUntilReset = null;
            String lastBuyingPlayer = null;
            try {
                timeUntilReset = timeUntilResetField.getInt(villager);
                lastBuyingPlayer = (String)lastBuyingPlayerField.get(villager);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (!villager.func_70940_q() && timeUntilReset != null && timeUntilReset == 39 && lastBuyingPlayer != null) {
                this.updateHatLevel(villager, lastBuyingPlayer);
            }
        }
        if (!villager.field_70170_p.field_72995_K && buyingListField != null) {
            this.updateMerchantRecipeList(villager);
        }
    }

    @Unique
    private void updateHatLevel(EntityVillager villager, String playerName) {
        EntityPlayer player = villager.field_70170_p.func_72924_a(playerName);
        if (player == null) {
            return;
        }
        ItemStack hat = player.field_71071_by.field_70460_b[3];
        if (hat != null && (hat.func_77973_b() == SteamcraftItems.tophat || hat.func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)Objects.requireNonNull(hat.func_77973_b())).hasUpgrade(hat, SteamcraftItems.tophat))) {
            NBTTagCompound tagCompound;
            if (!hat.func_77942_o()) {
                hat.func_77982_d(new NBTTagCompound());
            }
            if (!(tagCompound = hat.func_77978_p()).func_74764_b("level")) {
                tagCompound.func_74768_a("level", 0);
            }
            int level = tagCompound.func_74762_e("level");
            tagCompound.func_74768_a("level", ++level);
            if (hat.func_77973_b() == SteamcraftItems.exoArmorHead) {
                ((ItemExosuitArmor)Objects.requireNonNull(hat.func_77973_b())).setInventorySlotContents(player.field_71071_by.field_70460_b[3], 3, hat);
            }
        }
    }

    @Unique
    private void updateMerchantRecipeList(EntityVillager villager) {
        ExtendedPropertiesVillager nbt = (ExtendedPropertiesVillager)villager.getExtendedProperties(Steamcraft.VILLAGER_PROPERTY_ID);
        if (nbt.lastHadCustomer == null) {
            nbt.lastHadCustomer = false;
        }
        boolean hasCustomer = false;
        EntityPlayer customer = villager.func_70931_l_();
        if (customer != null) {
            MerchantRecipe recipe;
            MerchantRecipeList recipeList;
            ItemStack hat = customer.field_71071_by.field_70460_b[3];
            if (hat != null && (hat.func_77973_b() == SteamcraftItems.tophat || hat.func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)hat.func_77973_b()).hasUpgrade(hat, SteamcraftItems.tophat))) {
                hasCustomer = true;
                if (Boolean.FALSE.equals(nbt.lastHadCustomer)) {
                    recipeList = villager.func_70934_b(customer);
                    for (Object obj : recipeList) {
                        recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                        }
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                    }
                    try {
                        buyingListField.set(villager, recipeList);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!hasCustomer && Boolean.TRUE.equals(nbt.lastHadCustomer) && (recipeList = this.getMerchantRecipeList(villager)) != null) {
                for (Object obj : recipeList) {
                    recipe = (MerchantRecipe)obj;
                    if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                        recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                        continue;
                    }
                    if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                        recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                        continue;
                    }
                    if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                    recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                }
                try {
                    buyingListField.set(villager, recipeList);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            nbt.lastHadCustomer = hasCustomer;
        }
    }

    @Unique
    private MerchantRecipeList getMerchantRecipeList(EntityVillager villager) {
        try {
            return (MerchantRecipeList)buyingListField.get(villager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

