/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.gardenstuff;

import com.jaquadro.minecraft.gardentrees.world.gen.feature.WorldGenCandelilla;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={WorldGenCandelilla.class})
public class MixinWorldGenCandelilla
extends WorldGenerator
implements IWorldGenerator {
    @Shadow
    Block plantBlock;

    private boolean canGenerate(World world, int x, int y, int z) {
        if (y <= 0 || y >= world.func_72800_K() - 1) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        return block.isLeaves((IBlockAccess)world, x, y, z) || block.isAir((IBlockAccess)world, x, y, z);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        while (this.canGenerate(world, x, y, z)) {
            --y;
        }
        int range = 5;
        for (int l = 0; l < 32; ++l) {
            int x1 = x + rand.nextInt(range) - rand.nextInt(range);
            int y1 = y + rand.nextInt(4) - rand.nextInt(4);
            int z1 = z + rand.nextInt(range) - rand.nextInt(range);
            int level = 1 + rand.nextInt(7);
            if (!world.func_147437_c(x1, y1, z1) || world.field_73011_w.field_76576_e && y1 >= 255 || !this.plantBlock.func_149718_j(world, x1, y1, z1)) continue;
            world.func_147465_d(x1, y1, z1, this.plantBlock, level, 2);
        }
        return true;
    }

    @Overwrite(remap=false)
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int y;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biome = world.func_72807_a(x + 8, z + 8);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && random.nextInt(10) == 0 && (y = world.func_72825_h(x, z)) > 0) {
            this.func_76484_a(world, random, x + 8, y - 1, z + 8);
        }
    }
}

