/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.goblins;

import goblin.MobSpawnerGoblinLogic;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MobSpawnerGoblinLogic.class})
public abstract class MixinMobSpawnerGoblinLogic {
    @Shadow
    public int spawnDelay = 20;
    @Shadow
    private String entityTypeName = "Pig";
    @Shadow
    private char goblinType = (char)103;
    @Shadow
    private int goblinsLeft = 10;
    @Shadow
    private List potentialEntitySpawns;
    @Shadow
    private MobSpawnerGoblinLogic.WeightedRandomMinecart randomEntity;
    @Shadow
    public double field_98287_c;
    @Shadow
    public double field_98284_d;
    @Shadow
    private int minSpawnDelay = 400;
    @Shadow
    private int maxSpawnDelay = 800;
    @Shadow
    private int spawnCount = 2;
    @Shadow
    private Entity field_98291_j;
    @Shadow
    private int maxNearbyEntities = 6;
    @Shadow
    private int activatingRangeFromPlayer = 16;
    @Shadow
    private int spawnRange = 1;

    @Overwrite(remap=false)
    public void updateSpawner() {
        if (this.isActivated()) {
            if (this.goblinsLeft <= 0) {
                this.getSpawnerWorld().func_147465_d(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), Blocks.field_150347_e, 0, 2);
            }
            if (this.getSpawnerWorld().field_72995_K) {
                double d0 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d1 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d2 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
                this.getSpawnerWorld().func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                this.getSpawnerWorld().func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.field_98284_d = this.field_98287_c;
                this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                if (this.goblinsLeft > 0) {
                    for (int i = 0; i < this.spawnCount; ++i) {
                        Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.getSpawnerWorld());
                        if (entity == null) {
                            return;
                        }
                        AxisAlignedBB spawnAABB = AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2));
                        int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), spawnAABB).size();
                        if (j >= this.maxNearbyEntities) {
                            this.resetTimer();
                            return;
                        }
                        double d2 = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        double d3 = this.getSpawnerY() + 2;
                        double d4 = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        entity.func_70012_b(d2, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (this.goblinType == 'r') {
                            Entity entity1 = EntityList.func_75620_a((String)"goblin.Direwolf", (World)this.getSpawnerWorld());
                            entity1.func_70012_b(d2, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                            this.func_98265_a(entity1);
                        }
                        this.func_98265_a(entity);
                        --this.goblinsLeft;
                        this.getSpawnerWorld().func_72926_e(2004, this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                        }
                        flag = true;
                    }
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        } else {
            this.goblinsLeft = 10;
        }
    }

    @Overwrite(remap=false)
    public Entity func_98265_a(Entity par1Entity) {
        if (this.getRandomEntity() != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            par1Entity.func_70039_c(nbttagcompound);
            for (Object object : this.getRandomEntity().field_98222_b.func_150296_c()) {
                String s = (String)object;
                NBTBase nbtbase = this.getRandomEntity().field_98222_b.func_74781_a(s);
                nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
            }
            par1Entity.func_70020_e(nbttagcompound);
            if (par1Entity.field_70170_p != null) {
                par1Entity.field_70170_p.func_72838_d(par1Entity);
            }
            Entity entity1 = par1Entity;
            while (nbttagcompound.func_150297_b("Riding", 10)) {
                NBTTagCompound nbttagcompound2 = nbttagcompound.func_74775_l("Riding");
                Entity entity2 = EntityList.func_75620_a((String)nbttagcompound2.func_74779_i("id"), (World)par1Entity.field_70170_p);
                if (entity2 != null) {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    entity2.func_70039_c(nbttagcompound1);
                    for (Object o : nbttagcompound2.func_150296_c()) {
                        String s1 = (String)o;
                        NBTBase nbtbase1 = nbttagcompound2.func_74781_a(s1);
                        nbttagcompound1.func_74782_a(s1, nbtbase1.func_74737_b());
                    }
                    entity2.func_70020_e(nbttagcompound1);
                    assert (entity1 != null);
                    entity2.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity1.field_70177_z, entity1.field_70125_A);
                    if (par1Entity.field_70170_p != null) {
                        par1Entity.field_70170_p.func_72838_d(entity2);
                    }
                    entity1.func_70078_a(entity2);
                }
                entity1 = entity2;
                nbttagcompound = nbttagcompound2;
            }
        } else if (par1Entity instanceof EntityLivingBase && par1Entity.field_70170_p != null) {
            ((EntityLiving)par1Entity).func_110161_a(null);
            this.getSpawnerWorld().func_72838_d(par1Entity);
        }
        return par1Entity;
    }

    @Shadow
    public boolean isActivated() {
        return this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer) != null;
    }

    @Shadow
    public abstract void func_98267_a(int var1);

    @Shadow
    public abstract World getSpawnerWorld();

    @Shadow
    public abstract int getSpawnerX();

    @Shadow
    public abstract int getSpawnerY();

    @Shadow
    public abstract int getSpawnerZ();

    @Shadow
    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (this.potentialEntitySpawns != null && !this.potentialEntitySpawns.isEmpty()) {
            this.setRandomEntity((MobSpawnerGoblinLogic.WeightedRandomMinecart)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, (Collection)this.potentialEntitySpawns));
        }
        this.func_98267_a(1);
    }

    @Shadow
    public void setRandomEntity(MobSpawnerGoblinLogic.WeightedRandomMinecart par1WeightedRandomMinecart) {
        this.randomEntity = par1WeightedRandomMinecart;
    }

    @Shadow
    public String getEntityNameToSpawn() {
        if (this.goblinType == 'g') {
            int goblinPick = this.getSpawnerWorld().field_73012_v.nextInt(20);
            if (goblinPick <= 8) {
                return "goblin.Goblin";
            }
            if (goblinPick <= 13) {
                return "goblin.GOBLINEntityGoblinRanger";
            }
            return goblinPick <= 18 ? "goblin.GoblinSoldier" : "goblin.GoblinBomber";
        }
        if (this.goblinType == 'm') {
            return "goblin.GoblinMiner";
        }
        return this.goblinType == 'r' ? "goblin.GoblinRider" : "goblin.Goblin";
    }

    @Shadow
    public MobSpawnerGoblinLogic.WeightedRandomMinecart getRandomEntity() {
        return this.randomEntity;
    }
}

