/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.matmos;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SheetDataPackage.class})
public class MixinSheetDataPackage
implements DataPackage {
    @Unique
    private final Map<String, Sheet> sheets = new HashMap<String, Sheet>();
    @Shadow
    private final Class<? extends Sheet> sheetType;
    @Unique
    private final Set<Integer> referencedBlockIDs = new HashSet<Integer>();
    @Unique
    private final Set<Integer> referencedItemIDs = new HashSet<Integer>();

    public MixinSheetDataPackage(Class<? extends Sheet> sheetType) {
        this.sheetType = sheetType;
    }

    @Overwrite(remap=false)
    public Sheet getSheet(String name) {
        return this.sheets.computeIfAbsent(name, k -> {
            try {
                return this.sheetType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Overwrite(remap=false)
    public Set<String> getSheetNames() {
        return Collections.unmodifiableSet(this.sheets.keySet());
    }

    @Overwrite(remap=false)
    public void clear() {
        this.sheets.clear();
    }

    @Overwrite(remap=false)
    public void clearContents() {
        this.sheets.values().forEach(Sheet::clear);
    }

    @Overwrite(remap=false)
    public void addReferencedIDs(List<Integer> newReferencedBlockIDs, List<Integer> newReferencedItemIDs) {
        this.referencedBlockIDs.addAll(newReferencedBlockIDs);
        this.referencedItemIDs.addAll(newReferencedItemIDs);
    }

    @Overwrite(remap=false)
    public boolean isIDReferenced(int id, boolean isItem) {
        return (isItem ? this.referencedItemIDs : this.referencedBlockIDs).contains(id);
    }
}

